/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.Jira6xServiceDeskPluginLicenseSupplier;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.IteratorUtils;

public class BuildVersionLicenseCheckImpl
implements BuildVersionLicenseCheck {
    private final JiraLicenseManager licenseManager;
    private final ApplicationManager applicationManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper i18n;
    private final DateTimeFormatter dateTimeFormatter;
    private final Jira6xServiceDeskPluginLicenseSupplier serviceDeskLicense;

    public BuildVersionLicenseCheckImpl(@Nonnull JiraLicenseManager licenseManager, @Nonnull ApplicationManager applicationManager, @Nonnull BuildUtilsInfo buildUtilsInfo, @Nonnull I18nHelper i18n, @Nonnull DateTimeFormatter dateTimeFormatter, @Nonnull Jira6xServiceDeskPluginLicenseSupplier serviceDeskLicense) {
        this.licenseManager = licenseManager;
        this.applicationManager = applicationManager;
        this.buildUtilsInfo = buildUtilsInfo;
        this.i18n = i18n;
        this.dateTimeFormatter = dateTimeFormatter.withSystemZone();
        this.serviceDeskLicense = serviceDeskLicense;
    }

    @Override
    public LicenseCheck.Result evaluate() {
        return this.evaluate(true);
    }

    @Override
    public LicenseCheck.Result evaluateWithoutGracePeriod() {
        return this.evaluate(false);
    }

    private LicenseCheck.Result evaluate(boolean considerGracePeriodStatus) {
        Iterable<LicenseDetails> licenses = this.getLicenses();
        if (Iterables.isEmpty(licenses)) {
            return FAIL_NO_LICENSES;
        }
        Iterable ancientLicenses = Iterables.filter(licenses, license -> license.getLicenseVersion() == 1);
        if (!Iterables.isEmpty((Iterable)ancientLicenses)) {
            return new LicenseCheck.Failure((List<LicenseDetails>)ImmutableList.copyOf((Iterable)ancientLicenses), this.i18n.getText("setup.error.invalidlicensekey.v1.license.version"));
        }
        if (considerGracePeriodStatus && this.licenseManager.hasLicenseTooOldForBuildConfirmationBeenDone()) {
            return PASS;
        }
        if (this.allLicensesAreELAs(licenses)) {
            return PASS;
        }
        List<LicenseDetails> licensesPastMaintenance = this.filterLicensesPastMaintenance(licenses);
        if (licensesPastMaintenance.isEmpty()) {
            return PASS;
        }
        return new LicenseCheck.Failure(licensesPastMaintenance, this.getMaintenanceDateFailureMessage(licensesPastMaintenance));
    }

    private Iterable<LicenseDetails> getLicenses() {
        Iterable licenses = this.licenseManager.getLicenses();
        Option<LicenseDetails> sdLicense = this.licenseManager.isLicensed(ApplicationKeys.SERVICE_DESK) ? Option.none() : this.serviceDeskLicense.get();
        return Iterables.concat((Iterable)licenses, sdLicense);
    }

    private List<LicenseDetails> filterLicensesPastMaintenance(Iterable<LicenseDetails> licenses) {
        HashSet<LicenseDetails> licensesPastMaintenance = new HashSet<LicenseDetails>();
        Date plaftormBuildDate = this.buildUtilsInfo.getCurrentBuildDate();
        for (LicenseDetails license : licenses) {
            Set licensedApplicationKeys = license.getLicensedApplications().getKeys();
            for (ApplicationKey key : licensedApplicationKeys) {
                Date buildDate;
                Option appOption = this.applicationManager.getApplication(key);
                if (!appOption.isDefined() || license.isMaintenanceValidForBuildDate(buildDate = ((Application)appOption.get()).buildDate().toDate())) continue;
                licensesPastMaintenance.add(license);
            }
            if (license.isMaintenanceValidForBuildDate(plaftormBuildDate)) continue;
            licensesPastMaintenance.add(license);
        }
        return IteratorUtils.toList(licensesPastMaintenance.iterator());
    }

    private boolean allLicensesAreELAs(Iterable<LicenseDetails> licenses) {
        for (LicenseDetails license : licenses) {
            if (license.isEnterpriseLicenseAgreement()) continue;
            return false;
        }
        return true;
    }

    private String getMaintenanceDateFailureMessage(List<LicenseDetails> licensesPastMaintenance) {
        String expiredAppDescription = licensesPastMaintenance.stream().map(LicenseDetails::getApplicationDescription).collect(Collectors.joining(", "));
        Date expiryDateOfInstance = licensesPastMaintenance.stream().map(LicenseDetails::getMaintenanceExpiryDate).min(Date::compareTo).get();
        return this.i18n.getText("admin.license.build.update.not.possible", this.buildUtilsInfo.getVersion(), this.dateTimeFormatter.format(expiryDateOfInstance), expiredAppDescription);
    }
}

