/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractDateOperatorQueryFactory {
    private final JqlDateSupport jqlDateSupport;

    protected AbstractDateOperatorQueryFactory(JqlDateSupport jqlDateSupport) {
        this.jqlDateSupport = (JqlDateSupport)Assertions.notNull((String)"jqlDateSupport", (Object)jqlDateSupport);
    }

    List<Date> getDateValues(List<QueryLiteral> rawValues) {
        ArrayList dates = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            Date date;
            if (rawValue.getLongValue() != null) {
                date = this.jqlDateSupport.convertToDate(rawValue.getLongValue());
                if (date == null) continue;
                dates.add(date);
                continue;
            }
            if (rawValue.getStringValue() != null) {
                date = this.jqlDateSupport.convertToDate(rawValue.getStringValue());
                if (date == null) continue;
                dates.add(date);
                continue;
            }
            dates.add(null);
        }
        return dates;
    }
}

