/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.watchers;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueWatcherAddedEvent;
import com.atlassian.jira.event.issue.IssueWatcherDeletedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultWatcherManager
implements WatcherManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWatcherManager.class);
    public static final String ASSOCIATION_TYPE = "WatchIssue";
    private final UserAssociationStore userAssociationStore;
    private final ApplicationProperties applicationProperties;
    private final IssueIndexManager indexManager;
    private final IssueFactory issueFactory;
    private final EventPublisher eventPublisher;
    private final IssueManager issueManager;

    public DefaultWatcherManager(UserAssociationStore userAssociationStore, ApplicationProperties applicationProperties, IssueIndexManager indexManager, IssueFactory issueFactory, EventPublisher eventPublisher, IssueManager issueManager) {
        this.userAssociationStore = userAssociationStore;
        this.applicationProperties = applicationProperties;
        this.indexManager = indexManager;
        this.issueFactory = issueFactory;
        this.eventPublisher = eventPublisher;
        this.issueManager = issueManager;
    }

    @Nonnull
    public Issue startWatching(ApplicationUser user, Issue issue) {
        return (Issue)Iterables.getOnlyElement(this.startWatching(user, (Collection<Issue>)ImmutableList.of((Object)issue), Contexts.nullContext()));
    }

    @Nonnull
    public Collection<Issue> startWatching(@Nonnull ApplicationUser user, @Nonnull Collection<Issue> issues, @Nonnull Context taskContext) {
        ArrayList updatedIssues = Lists.newArrayListWithCapacity((int)issues.size());
        for (Issue issue : issues) {
            Context.Task task = taskContext.start((Object)issue);
            updatedIssues.add(this.updateWatch(true, user, issue));
            task.complete();
        }
        this.reindex(updatedIssues);
        return updatedIssues;
    }

    @Nonnull
    public Issue stopWatching(ApplicationUser user, Issue issue) {
        return (Issue)Iterables.getOnlyElement(this.stopWatching(user, (Collection<Issue>)ImmutableList.of((Object)issue), Contexts.nullContext()));
    }

    @Nonnull
    public Collection<Issue> stopWatching(ApplicationUser user, Collection<Issue> issues, Context taskContext) {
        ArrayList<Issue> updatedIssues = new ArrayList<Issue>(issues.size());
        for (Issue issue : issues) {
            Context.Task task = taskContext.start((Object)issue);
            updatedIssues.add(this.updateWatch(false, user, issue));
            task.complete();
        }
        this.reindex(updatedIssues);
        return updatedIssues;
    }

    public List<String> getCurrentWatcherUsernames(Issue issue) throws DataAccessException {
        return this.userAssociationStore.getUsernamesFromSink(ASSOCIATION_TYPE, issue.getGenericValue());
    }

    public boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    public boolean isWatching(@Nullable ApplicationUser user, Issue issue) {
        if (user == null) {
            return false;
        }
        Long watches = issue.getWatches();
        return watches != null && watches != 0L && this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, "Issue", issue.getId());
    }

    public List<ApplicationUser> getWatchers(Issue issue, Locale userLocale) {
        List<ApplicationUser> watchers = this.userAssociationStore.getUsersFromSink(ASSOCIATION_TYPE, issue.getGenericValue());
        Collections.sort(watchers, new ApplicationUserBestNameComparator(userLocale));
        return watchers;
    }

    public int getWatcherCount(Issue issue) {
        return this.userAssociationStore.getUserkeysFromIssue(ASSOCIATION_TYPE, issue.getId()).size();
    }

    public Collection<String> getWatcherUserKeys(Issue issue) {
        return this.userAssociationStore.getUserkeysFromIssue(ASSOCIATION_TYPE, issue.getId());
    }

    private Issue updateWatch(boolean addWatch, @Nullable ApplicationUser user, Issue issue) {
        if (this.validateUpdate(user)) {
            try {
                if (addWatch) {
                    if (!this.isWatching(user, issue)) {
                        this.userAssociationStore.createAssociation(ASSOCIATION_TYPE, user, issue);
                        Issue updatedIssue = this.adjustWatchCount(issue, 1);
                        this.eventPublisher.publish((Object)new IssueWatcherAddedEvent(updatedIssue, user));
                        return updatedIssue;
                    }
                } else if (this.isWatching(user, issue)) {
                    this.userAssociationStore.removeAssociation(ASSOCIATION_TYPE, user, issue);
                    Issue updatedIssue = this.adjustWatchCount(issue, -1);
                    this.eventPublisher.publish((Object)new IssueWatcherDeletedEvent(updatedIssue, user));
                    return updatedIssue;
                }
            }
            catch (GenericEntityException e) {
                log.error("Error changing watch association", (Throwable)e);
                return issue;
            }
        }
        return issue;
    }

    private boolean validateUpdate(@Nullable ApplicationUser user) {
        if (user == null) {
            log.error("You must specify a user.");
            return false;
        }
        return true;
    }

    private Issue adjustWatchCount(Issue originalIssue, int adjustValue) throws GenericEntityException {
        long watches = this.recalculateWatches(originalIssue, adjustValue);
        Long issueId = originalIssue.getId();
        GenericValue clonedIssue = (GenericValue)originalIssue.getGenericValue().clone();
        clonedIssue.clear();
        clonedIssue.set("id", (Object)issueId);
        clonedIssue.set("watches", (Object)watches);
        clonedIssue.store();
        return this.issueManager.getIssueObject(issueId);
    }

    private long recalculateWatches(Issue issue, int adjustValue) {
        Long watches = issue.getWatches();
        if (watches == null) {
            watches = 0L;
        }
        if ((watches = Long.valueOf(watches + (long)adjustValue)) < 0L) {
            watches = 0L;
        }
        return watches;
    }

    public void removeAllWatchesForUser(ApplicationUser user) {
        Assertions.notNull((String)"User", (Object)user);
        List<GenericValue> watchedIssues = this.userAssociationStore.getSinksFromUser(ASSOCIATION_TYPE, user, "Issue");
        this.userAssociationStore.removeUserAssociationsFromUser(ASSOCIATION_TYPE, user, "Issue");
        this.reindex(watchedIssues.stream().map(arg_0 -> ((IssueFactory)this.issueFactory).getIssue(arg_0)).map(issue -> {
            this.eventPublisher.publish((Object)new IssueWatcherDeletedEvent((Issue)issue, user));
            return issue;
        }).collect(Collectors.toList()));
    }

    private void reindex(Collection<Issue> issues) {
        try {
            this.indexManager.reIndexIssueObjects(issues, IssueIndexingParams.INDEX_ISSUE_ONLY);
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }
}

