/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.vote;

import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.vote.VoteHistoryEntry;
import com.atlassian.jira.issue.vote.VoteHistoryEntryImpl;
import com.atlassian.jira.issue.vote.VoteHistoryStore;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVoteManager
implements VoteManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultVoteManager.class);
    private static final String ASSOCIATION_TYPE = "VoteIssue";
    private final ApplicationProperties applicationProperties;
    private final UserAssociationStore userAssociationStore;
    private final VoteHistoryStore voteHistoryStore;
    private final IssueIndexManager indexManager;
    private final IssueManager issueManager;

    public DefaultVoteManager(ApplicationProperties applicationProperties, UserAssociationStore userAssociationStore, IssueIndexManager indexManager, VoteHistoryStore voteHistoryStore, IssueManager issueManager) {
        this.applicationProperties = applicationProperties;
        this.userAssociationStore = userAssociationStore;
        this.indexManager = indexManager;
        this.voteHistoryStore = voteHistoryStore;
        this.issueManager = issueManager;
    }

    public boolean addVote(ApplicationUser user, Issue issue) {
        return this.updateVote(true, user, issue.getGenericValue());
    }

    public boolean addVote(ApplicationUser user, GenericValue issue) {
        return this.updateVote(true, user, issue);
    }

    public boolean removeVote(ApplicationUser user, GenericValue issue) {
        return this.updateVote(false, user, issue);
    }

    public boolean removeVote(ApplicationUser user, Issue issue) {
        return this.updateVote(false, user, issue.getGenericValue());
    }

    public Collection<String> getVoterUsernames(Issue issue) {
        return this.getVoterUsernames(issue.getGenericValue());
    }

    public Collection<String> getVoterUsernames(GenericValue issue) {
        Collection<String> userkeys = this.userAssociationStore.getUserkeysFromSink(ASSOCIATION_TYPE, "Issue", issue.getLong("id"));
        ArrayList<String> usernames = new ArrayList<String>(userkeys.size());
        UserKeyService userKeyService = (UserKeyService)ComponentAccessor.getComponent(UserKeyService.class);
        for (String userkey : userkeys) {
            usernames.add(userKeyService.getUsernameForKey(userkey));
        }
        return usernames;
    }

    public Collection<String> getVoterUserkeys(Issue issue) {
        return this.userAssociationStore.getUserkeysFromSink(ASSOCIATION_TYPE, "Issue", issue.getId());
    }

    public int getVoteCount(Issue issue) {
        return this.getVoterUsernames(issue).size();
    }

    public List<VoteHistoryEntry> getVoteHistory(Issue issue) {
        return this.voteHistoryStore.getHistory(issue.getId());
    }

    public List<ApplicationUser> getVoters(Issue issue, Locale usersLocale) {
        return this.getVoters(issue.getGenericValue(), usersLocale);
    }

    public List<ApplicationUser> getVotersFor(Issue issue, Locale usersLocale) {
        return this.getVoters(issue.getGenericValue(), usersLocale);
    }

    private List<ApplicationUser> getVoters(GenericValue issueGV, Locale usersLocale) {
        List<ApplicationUser> voters = this.userAssociationStore.getUsersFromSink(ASSOCIATION_TYPE, issueGV);
        Collections.sort(voters, new ApplicationUserBestNameComparator(usersLocale));
        return voters;
    }

    private boolean updateVote(boolean isVoting, ApplicationUser user, GenericValue issue) {
        if (this.validateUpdate(user, issue)) {
            try {
                if (isVoting) {
                    if (!this.hasVoted(user, issue)) {
                        this.userAssociationStore.createAssociation(ASSOCIATION_TYPE, user, issue);
                        this.adjustVoteCount(issue, 1);
                        return true;
                    }
                } else if (this.hasVoted(user, issue)) {
                    this.userAssociationStore.removeAssociation(ASSOCIATION_TYPE, user.getKey(), "Issue", issue.getLong("id"));
                    this.adjustVoteCount(issue, -1);
                    return true;
                }
            }
            catch (GenericEntityException e) {
                log.error("Error changing vote association", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private void adjustVoteCount(GenericValue originalIssue, int adjustValue) throws GenericEntityException {
        long votes = this.recalculateVoters(originalIssue, adjustValue);
        Long issueId = originalIssue.getLong("id");
        GenericValue clonedIssue = (GenericValue)originalIssue.clone();
        clonedIssue.clear();
        clonedIssue.set("id", (Object)originalIssue.getLong("id"));
        clonedIssue.set("votes", (Object)votes);
        clonedIssue.store();
        originalIssue.set("votes", (Object)votes);
        Timestamp now = new Timestamp(new Date().getTime());
        this.voteHistoryStore.add(new VoteHistoryEntryImpl(originalIssue.getLong("id"), now, votes));
        try {
            GenericValue updatedIssue = this.issueManager.getIssue(issueId);
            this.indexManager.reIndex(updatedIssue);
        }
        catch (IndexException e) {
            log.error("Exception re-indexing issue " + (Object)((Object)e), (Throwable)e);
        }
    }

    private Long recalculateVoters(GenericValue issue, int adjustValue) {
        Long votes = issue.getLong("votes");
        if (votes == null) {
            votes = 0L;
        }
        if ((votes = Long.valueOf(votes + (long)adjustValue)) < 0L) {
            votes = 0L;
        }
        return votes;
    }

    private boolean validateUpdate(ApplicationUser user, GenericValue issue) {
        if (issue == null) {
            log.error("You must specify an issue.");
            return false;
        }
        if (!this.isVotingEnabled()) {
            log.error("Voting is not enabled - the change vote on issue " + issue.getString("key") + " by user " + user.getUsername() + " was unsuccessful.");
            return false;
        }
        if (issue.getString("resolution") != null) {
            log.error("Cannot change vote on issue that has been resolved.");
            return false;
        }
        if (user == null) {
            log.error("You must specify a user.");
            return false;
        }
        return true;
    }

    public boolean isVotingEnabled() {
        return this.applicationProperties.getOption("jira.option.voting");
    }

    public boolean hasVoted(ApplicationUser user, Issue issue) {
        if (user == null) {
            return false;
        }
        if (issue.getVotes() == 0L) {
            return false;
        }
        return this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, "Issue", issue.getId());
    }

    public boolean hasVoted(ApplicationUser user, GenericValue issue) {
        if (user == null) {
            return false;
        }
        if (issue.getLong("votes") == 0L) {
            return false;
        }
        return this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, "Issue", issue.getLong("id"));
    }

    public void removeVotesForUser(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        List<GenericValue> issueGvs = this.userAssociationStore.getSinksFromUser(ASSOCIATION_TYPE, user, "Issue");
        for (GenericValue issueGv : issueGvs) {
            this.updateVote(false, user, issueGv);
        }
    }
}

