/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.SearchLinkGenerator;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.annotations.VisibleForTesting;

public class DefaultSearchLinkGenerator
implements SearchLinkGenerator {
    @VisibleForTesting
    static final String SIDEBAR_DARK_FEATURE_KEY = "com.atlassian.jira.projects.ProjectCentricNavigation";
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public DefaultSearchLinkGenerator(ProjectManager projectManager, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    @HtmlSafe
    public String getComponentSearchLink(ProjectComponent component) {
        if (component == null) {
            return "";
        }
        DarkFeatureManager darkFeatureManager = (DarkFeatureManager)ComponentAccessor.getOSGiComponentInstanceOfType(DarkFeatureManager.class);
        if (darkFeatureManager.isFeatureEnabledForCurrentUser(SIDEBAR_DARK_FEATURE_KEY)) {
            Query projectAndComponent = JqlQueryBuilder.newBuilder().where().project(new String[]{this.projectManager.getProjectObj(component.getProjectId()).getKey()}).and().component(new String[]{component.getName()}).buildQuery();
            return this.getLinkForQuery(projectAndComponent);
        }
        return String.format("%s/browse/%s/component/%d", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl(), JiraUrlCodec.encode((String)this.projectManager.getProjectObj(component.getProjectId()).getKey()), component.getId());
    }

    @HtmlSafe
    public String getFixVersionSearchLink(Version version) {
        if (version == null) {
            return "";
        }
        DarkFeatureManager darkFeatureManager = (DarkFeatureManager)ComponentAccessor.getOSGiComponentInstanceOfType(DarkFeatureManager.class);
        if (darkFeatureManager.isFeatureEnabledForCurrentUser(SIDEBAR_DARK_FEATURE_KEY)) {
            Query projectAndFixVersion = JqlQueryBuilder.newBuilder().where().project(new String[]{version.getProjectObject().getKey()}).and().fixVersion(version.getName()).buildQuery();
            return this.getLinkForQuery(projectAndFixVersion);
        }
        return String.format("%s/browse/%s/fixforversion/%d", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl(), JiraUrlCodec.encode((String)version.getProjectObject().getKey()), version.getId());
    }

    private String getLinkForQuery(Query query) {
        return SearchRequestViewUtils.getLink(new SearchRequest(query), this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl(), this.authenticationContext.getUser());
    }
}

