/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IssueSecuritySchemeServiceImpl
implements IssueSecuritySchemeService {
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final I18nHelper i18n;

    public IssueSecuritySchemeServiceImpl(IssueSecuritySchemeManager issueSecuritySchemeManager, IssueSecurityLevelManager issueSecurityLevelManager, GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, I18nHelper i18n) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
    }

    public ServiceOutcome<? extends Collection<IssueSecurityLevelScheme>> getIssueSecurityLevelSchemes(ApplicationUser user) {
        return this.asAdmin(user, new ServiceAction<Collection<IssueSecurityLevelScheme>>(){

            @Override
            public ServiceOutcome<Collection<IssueSecurityLevelScheme>> perform() {
                return ServiceOutcomeImpl.ok(IssueSecuritySchemeServiceImpl.this.issueSecuritySchemeManager.getIssueSecurityLevelSchemes());
            }
        });
    }

    private boolean canViewSchemeAsProjectAdmin(ApplicationUser user, long schemeId) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.ADMINISTER_PROJECTS, user);
        return !Collections.disjoint(projects, this.issueSecuritySchemeManager.getProjectsUsingScheme(schemeId));
    }

    public ServiceOutcome<IssueSecurityLevelScheme> getIssueSecurityLevelScheme(ApplicationUser user, final long schemeId) {
        return this.asAdminOrProjectAdminWithAccessToScheme(user, schemeId, new ServiceAction<IssueSecurityLevelScheme>(){

            @Override
            public ServiceOutcome<IssueSecurityLevelScheme> perform() {
                Supplier notFoundSupplier = IssueSecuritySchemeServiceImpl.this.notFoundSupplier("rest.error.issuesecurityscheme.securityscheme.not.found", new String[]{String.valueOf(schemeId)});
                return (ServiceOutcome)Option.option((Object)IssueSecuritySchemeServiceImpl.this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(Long.valueOf(schemeId))).fold(notFoundSupplier, IssueSecuritySchemeServiceImpl.okOutcome());
            }
        });
    }

    public ServiceOutcome<? extends List<IssueSecurityLevel>> getIssueSecurityLevels(ApplicationUser user, final long schemeId) {
        return this.asAdminOrProjectAdminWithAccessToScheme(user, schemeId, new ServiceAction<List<IssueSecurityLevel>>(){

            @Override
            public ServiceOutcome<List<IssueSecurityLevel>> perform() {
                Supplier notFoundSupplier = IssueSecuritySchemeServiceImpl.this.notFoundSupplier("rest.error.issuesecurityscheme.securityscheme.not.found", new String[]{String.valueOf(schemeId)});
                return (ServiceOutcome)Option.option((Object)IssueSecuritySchemeServiceImpl.this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(Long.valueOf(schemeId))).fold(notFoundSupplier, (Function)new Function<IssueSecurityLevelScheme, ServiceOutcome<List<IssueSecurityLevel>>>(){

                    public ServiceOutcome<List<IssueSecurityLevel>> apply(IssueSecurityLevelScheme securityLevelScheme) {
                        return ServiceOutcomeImpl.ok(IssueSecuritySchemeServiceImpl.this.issueSecurityLevelManager.getIssueSecurityLevels(schemeId));
                    }
                });
            }
        });
    }

    public ServiceOutcome<IssueSecurityLevel> getIssueSecurityLevel(ApplicationUser user, final long securityLevelId) {
        return this.asAdmin(user, new ServiceAction<IssueSecurityLevel>(){

            @Override
            public ServiceOutcome<IssueSecurityLevel> perform() {
                Supplier notFoundSupplier = IssueSecuritySchemeServiceImpl.this.notFoundSupplier("rest.error.issuesecurityscheme.securitylevel.not.found", new String[]{String.valueOf(securityLevelId)});
                return (ServiceOutcome)Option.option((Object)IssueSecuritySchemeServiceImpl.this.issueSecurityLevelManager.getSecurityLevel(securityLevelId)).fold(notFoundSupplier, IssueSecuritySchemeServiceImpl.okOutcome());
            }
        });
    }

    public ServiceOutcome<? extends Collection<IssueSecurityLevelPermission>> getPermissionsByIssueSecurityLevel(ApplicationUser user, final long securityLevelId) {
        return this.asAdmin(user, new ServiceAction<Collection<IssueSecurityLevelPermission>>(){

            @Override
            public ServiceOutcome<Collection<IssueSecurityLevelPermission>> perform() {
                Supplier notFoundSupplier = IssueSecuritySchemeServiceImpl.this.notFoundSupplier("rest.error.issuesecurityscheme.securitylevel.not.found", new String[]{String.valueOf(securityLevelId)});
                return (ServiceOutcome)Option.option((Object)IssueSecuritySchemeServiceImpl.this.issueSecurityLevelManager.getSecurityLevel(securityLevelId)).fold(notFoundSupplier, (Function)new Function<IssueSecurityLevel, ServiceOutcome<Collection<IssueSecurityLevelPermission>>>(){

                    public ServiceOutcome<Collection<IssueSecurityLevelPermission>> apply(IssueSecurityLevel issueSecurityLevel) {
                        List collection = IssueSecuritySchemeServiceImpl.this.issueSecuritySchemeManager.getPermissionsBySecurityLevel(Long.valueOf(securityLevelId));
                        return ServiceOutcomeImpl.ok(collection);
                    }
                });
            }
        });
    }

    private static <T> Function<T, ServiceOutcome<T>> okOutcome() {
        return new Function<T, ServiceOutcome<T>>(){

            public ServiceOutcome<T> apply(T t) {
                return ServiceOutcomeImpl.ok(t);
            }
        };
    }

    private <T> Supplier<ServiceOutcome<T>> notFoundSupplier(final String i18nKey, final String ... params) {
        return new Supplier<ServiceOutcome<T>>(){

            public ServiceOutcome<T> get() {
                return ServiceOutcomeImpl.error(IssueSecuritySchemeServiceImpl.this.i18n.getText(i18nKey, (Object)params), ErrorCollection.Reason.NOT_FOUND);
            }
        };
    }

    private boolean isAdmin(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private <T> ServiceOutcome<T> asAdmin(final ApplicationUser user, ServiceAction<T> action) {
        return this.performActionWithUserPermissionCondition(user, new ParameterlessPredicate(){

            @Override
            public boolean apply() {
                return IssueSecuritySchemeServiceImpl.this.isAdmin(user);
            }
        }, action);
    }

    private <T> ServiceOutcome<T> asAdminOrProjectAdminWithAccessToScheme(final ApplicationUser user, final Long schemeId, ServiceAction<T> action) {
        return this.performActionWithUserPermissionCondition(user, new ParameterlessPredicate(){

            @Override
            public boolean apply() {
                return IssueSecuritySchemeServiceImpl.this.isAdmin(user) || IssueSecuritySchemeServiceImpl.this.canViewSchemeAsProjectAdmin(user, schemeId);
            }
        }, action);
    }

    private <T> ServiceOutcome<T> performActionWithUserPermissionCondition(ApplicationUser user, ParameterlessPredicate predicate, ServiceAction<T> action) {
        String forbiddenMessage = this.i18n.getText("admin.schemes.permissions.forbidden");
        if (user == null) {
            return ServiceOutcomeImpl.error(forbiddenMessage, ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        if (!predicate.apply()) {
            return ServiceOutcomeImpl.error(forbiddenMessage, ErrorCollection.Reason.FORBIDDEN);
        }
        return action.perform();
    }

    private static interface ParameterlessPredicate {
        public boolean apply();
    }

    private static interface ServiceAction<T> {
        public ServiceOutcome<T> perform();
    }
}

