/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.fugue.Option;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.index.EntitySearchExtractor;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.IssueSearchExtractor;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.json.JSONTokener;
import com.atlassian.query.clause.Property;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuePropertySearchExtractor
implements IssueSearchExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(IssuePropertySearchExtractor.class);
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final PluginIndexConfigurationManager entityPropertyIndexDocumentManager;
    private final DoubleConverter doubleConverter;
    private final Set<DateTimeFormatter> dateTimeFormatters;
    private final Set<DateTimeFormatter> dateOnlyFormatters;

    public IssuePropertySearchExtractor(JsonEntityPropertyManager jsonEntityPropertyManager, PluginIndexConfigurationManager entityPropertyIndexDocumentManager, DateTimeFormatterFactory dateTimeFormatterFactory, SearchExtractorRegistrationManager searchExtractorRegistrationManager, DoubleConverter doubleConverter) {
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.entityPropertyIndexDocumentManager = entityPropertyIndexDocumentManager;
        this.doubleConverter = doubleConverter;
        this.dateOnlyFormatters = ImmutableSet.of((Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_PICKER).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE).withDefaultLocale());
        this.dateTimeFormatters = ImmutableSet.of((Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.COMPLETE).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.DATE_TIME_PICKER).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).withDefaultLocale(), (Object)dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.RSS_RFC822_DATE_TIME).withDefaultLocale());
        searchExtractorRegistrationManager.register(this, Issue.class);
    }

    public Set<String> indexEntity(EntitySearchExtractor.Context<Issue> ctx, Document doc) {
        ImmutableSet.Builder fieldIdsBuilder = ImmutableSet.builder();
        Iterable<PluginIndexConfiguration> configurations = this.entityPropertyIndexDocumentManager.getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName());
        Iterable fieldsToAdd = Iterables.transform((Iterable)Iterables.transform(configurations, (Function)new Function<PluginIndexConfiguration, IndexDocumentConfiguration>(){

            public IndexDocumentConfiguration apply(PluginIndexConfiguration input) {
                return input.getIndexDocumentConfiguration();
            }
        }), (Function)new EntityPropertyIndexDocumentFieldableFunction((Issue)ctx.getEntity(), (ImmutableSet.Builder<String>)fieldIdsBuilder));
        for (Fieldable fieldable : Iterables.concat((Iterable)fieldsToAdd)) {
            doc.add(fieldable);
        }
        return fieldIdsBuilder.build();
    }

    private class ExtractConfigurationIterableFunction
    implements Function<IndexDocumentConfiguration.ExtractConfiguration, Iterable<Fieldable>> {
        private final Object jsonEntityProperty;
        private final ImmutableSet.Builder<String> filedIdsBuilder;
        private final String key;

        public ExtractConfigurationIterableFunction(Object jsonEntityProperty, ImmutableSet.Builder<String> filedIdsBuilder, String key) {
            this.jsonEntityProperty = jsonEntityProperty;
            this.filedIdsBuilder = filedIdsBuilder;
            this.key = key;
        }

        public Iterable<Fieldable> apply(IndexDocumentConfiguration.ExtractConfiguration extractConfiguration) {
            String path = extractConfiguration.getPath();
            Option<Object> value = this.getValueForPath(this.jsonEntityProperty, path);
            if (value.isEmpty()) {
                return Collections.emptyList();
            }
            Object jsonValue = value.get();
            if (jsonValue instanceof JSONArray) {
                JSONArray array = (JSONArray)jsonValue;
                ImmutableList.Builder fieldsForArray = ImmutableList.builder();
                for (int i = 0; i < array.length(); ++i) {
                    Option<? extends Fieldable> fieldableOption;
                    Object arrayElement = array.opt(i);
                    if (arrayElement == null || !(fieldableOption = this.getValueFromJsonObject(arrayElement, path, this.key, extractConfiguration.getType())).isDefined()) continue;
                    fieldsForArray.add(fieldableOption.get());
                }
                return fieldsForArray.build();
            }
            Option<? extends Fieldable> fieldableOption = this.getValueFromJsonObject(jsonValue, path, this.key, extractConfiguration.getType());
            if (fieldableOption.isDefined()) {
                return ImmutableList.of((Object)fieldableOption.get());
            }
            return Collections.emptyList();
        }

        private Option<? extends Fieldable> getValueFromJsonObject(Object value, String path, String key, IndexDocumentConfiguration.Type type) {
            if (value instanceof JSONObject || value instanceof JSONArray || value == null) {
                return Option.none();
            }
            String fieldName = "ISSUEPROP_" + new Property((List)ImmutableList.of((Object)key), (List)ImmutableList.of((Object)path)).getAsPropertyString();
            String fieldValue = value.toString();
            Field.Index analyze = Field.Index.NOT_ANALYZED_NO_NORMS;
            switch (type) {
                case NUMBER: {
                    try {
                        fieldValue = IssuePropertySearchExtractor.this.doubleConverter.getStringForLucene(fieldValue);
                        break;
                    }
                    catch (FieldValidationException e) {
                        LOG.debug(MessageFormat.format("Not adding field with name {0}, value {1} is invalid message {3}", fieldName, value, e.getMessage()));
                        return Option.none();
                    }
                }
                case DATE: {
                    Option<String> dateOption = this.getDateValue(fieldValue);
                    if (dateOption.isEmpty()) {
                        LOG.debug(MessageFormat.format("Not adding field with name {0}, value {1} cannot be parsed as date", fieldName, value));
                        return Option.none();
                    }
                    fieldValue = (String)dateOption.get();
                    break;
                }
                case TEXT: {
                    analyze = Field.Index.ANALYZED;
                    break;
                }
            }
            this.filedIdsBuilder.add((Object)fieldName);
            return Option.some((Object)new Field(fieldName, false, fieldValue, Field.Store.NO, analyze, Field.TermVector.NO));
        }

        private Option<String> getDateValue(String value) {
            Option<String> parsedDate = this.parseDateWithFormatter(value, IssuePropertySearchExtractor.this.dateTimeFormatters);
            if (parsedDate.isDefined()) {
                return parsedDate;
            }
            return this.parseDateWithFormatter(value, IssuePropertySearchExtractor.this.dateOnlyFormatters);
        }

        private Option<String> parseDateWithFormatter(String value, Iterable<DateTimeFormatter> formatters) {
            for (DateTimeFormatter formatter : formatters) {
                try {
                    Date parsedDate = formatter.parse(value);
                    if (parsedDate == null) continue;
                    return Option.some((Object)LuceneUtils.dateToString((Date)parsedDate));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            return Option.none();
        }

        private Option<Object> getValueForPath(Object jsonEntityProperty, String path) {
            String[] split = StringUtils.split((String)path, (char)'.');
            Object value = jsonEntityProperty;
            for (String currentKey : split) {
                if (value == null || !(value instanceof JSONObject)) {
                    return Option.none();
                }
                value = ((JSONObject)value).opt(currentKey);
            }
            return Option.option((Object)value);
        }
    }

    private class KeyConfigurationIterableFunction
    implements Function<IndexDocumentConfiguration.KeyConfiguration, Iterable<Fieldable>> {
        private final ImmutableSet.Builder<String> filedIdsBuilder;
        private final Long issueId;

        private KeyConfigurationIterableFunction(Long issueId, ImmutableSet.Builder<String> filedIdsBuilder) {
            this.issueId = issueId;
            this.filedIdsBuilder = filedIdsBuilder;
        }

        public Iterable<Fieldable> apply(IndexDocumentConfiguration.KeyConfiguration keyConfiguration) {
            EntityProperty entityProperty = IssuePropertySearchExtractor.this.jsonEntityPropertyManager.get(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName(), this.issueId, keyConfiguration.getPropertyKey());
            if (entityProperty == null) {
                return Collections.emptyList();
            }
            Option<Object> jsonEntityProperty = this.getJSON(entityProperty.getValue(), this.issueId, keyConfiguration.getPropertyKey());
            if (jsonEntityProperty.isEmpty()) {
                return Collections.emptyList();
            }
            return Iterables.concat((Iterable)Iterables.transform((Iterable)keyConfiguration.getExtractorConfigurations(), (Function)new ExtractConfigurationIterableFunction(jsonEntityProperty.get(), this.filedIdsBuilder, keyConfiguration.getPropertyKey())));
        }

        private Option<Object> getJSON(String jsonString, Long issueId, String entityKey) {
            try {
                JSONTokener jsonTokener = new JSONTokener(jsonString);
                Object value = jsonTokener.nextValue();
                if (jsonTokener.more()) {
                    return Option.none();
                }
                return Option.some((Object)value);
            }
            catch (JSONException e) {
                String message = MessageFormat.format("JSON stored in jsonEntityPropertyManagers is not valid for entityId='{'0'}' , entityName='{'1'}', entityKey='{'3'}'{0}", issueId.toString(), EntityPropertyType.ISSUE_PROPERTY.getDbEntityName(), entityKey);
                LOG.debug(message, (Throwable)e);
                return Option.none();
            }
        }
    }

    private class EntityPropertyIndexDocumentFieldableFunction
    implements Function<IndexDocumentConfiguration, Iterable<Fieldable>> {
        private final Issue issue;
        private final ImmutableSet.Builder<String> filedIdsBuilder;

        public EntityPropertyIndexDocumentFieldableFunction(Issue issue, ImmutableSet.Builder<String> filedIdsBuilder) {
            this.issue = issue;
            this.filedIdsBuilder = filedIdsBuilder;
        }

        public Iterable<Fieldable> apply(IndexDocumentConfiguration indexDocumentConfiguration) {
            return Iterables.concat((Iterable)Iterables.transform((Iterable)indexDocumentConfiguration.getKeyConfigurations(), (Function)new KeyConfigurationIterableFunction(this.issue.getId(), this.filedIdsBuilder)));
        }
    }
}

