/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import java.io.Reader;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public class GermanAnalyzer
extends TextAnalyzer {
    private final Version version;
    private final Function<TokenStream, TokenStream> stemmingFilter;
    private final Function<TokenStream, TokenStream> stopWordFilter;

    public GermanAnalyzer(Version version, boolean includeSubTokenFilter, Function<TokenStream, TokenStream> stemmingFilter, Function<TokenStream, TokenStream> stopWordFilter) {
        super(includeSubTokenFilter);
        this.stemmingFilter = stemmingFilter;
        this.stopWordFilter = stopWordFilter;
        this.version = version;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer result = new StandardTokenizer(this.version, reader);
        result = new StandardFilter(this.version, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.version, (TokenStream)result);
        result = (TokenStream)this.stopWordFilter.apply((Object)result);
        result = this.wrapStreamForWilcardSearchSupport((TokenStream)result);
        result = (TokenStream)this.stemmingFilter.apply((Object)result);
        return result;
    }
}

