/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.DefaultColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@ClusterSafe(value="Mostly, due to session affinity.  We should revisit this, but using a cluster lock would be overkill for the risk")
public class DefaultColumnLayoutManager
implements ColumnLayoutManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultColumnLayoutManager.class);
    private final Cache<CacheObject<String>, CacheableColumnLayout> userColumnLayoutCache;
    private final Cache<Long, CacheObject<CacheableColumnLayout>> filterColumnLayoutCache;
    private final OfBizDelegator ofBizDelegator;
    private final FieldManager fieldManager;
    private final ColumnLayout defaultColumnLayout;
    private final UserKeyService userKeyService;

    public DefaultColumnLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, UserKeyService userKeyService, CacheManager cacheManager) {
        this.fieldManager = fieldManager;
        this.ofBizDelegator = ofBizDelegator;
        this.userKeyService = userKeyService;
        this.userColumnLayoutCache = cacheManager.getCache(DefaultColumnLayoutManager.class.getName() + ".userColumnLayoutCache", (CacheLoader)new UserColumnLayoutCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.filterColumnLayoutCache = cacheManager.getCache(DefaultColumnLayoutManager.class.getName() + ".filterColumnLayoutCache", (CacheLoader)new FilterColumnLayoutCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        int pos = 0;
        ArrayList cols = Lists.newArrayListWithCapacity((int)11);
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("issuetype"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("issuekey"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("summary"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("assignee"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("reporter"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("priority"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("status"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("resolution"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("created"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("updated"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("duedate"), pos++));
        this.defaultColumnLayout = new DefaultColumnLayoutImpl((List<ColumnLayoutItem>)ImmutableList.copyOf((Collection)cols));
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public void refresh() {
        this.userColumnLayoutCache.removeAll();
        this.filterColumnLayoutCache.removeAll();
    }

    public ColumnLayout getColumnLayout(ApplicationUser remoteUser) throws ColumnLayoutStorageException {
        String username = remoteUser == null ? null : remoteUser.getName();
        CacheableColumnLayout cacheableColumnLayout = this.getUserColumnLayout(username);
        List<ColumnLayoutItem> columnLayoutItems = this.removeUnavailableColumnLayoutItemsForUser(cacheableColumnLayout.columnLayoutItems, remoteUser);
        return new UserColumnLayoutImpl(columnLayoutItems, remoteUser, cacheableColumnLayout.columnConfig);
    }

    public ColumnLayout getDefaultColumnLayout(ApplicationUser remoteUser) throws ColumnLayoutStorageException {
        CacheableColumnLayout defaultColumnLayout = this.getUserColumnLayout(null);
        List<ColumnLayoutItem> columnLayoutItems = this.removeUnavailableColumnLayoutItemsForUser(defaultColumnLayout.columnLayoutItems, remoteUser);
        return new DefaultColumnLayoutImpl(columnLayoutItems);
    }

    public ColumnLayout getDefaultColumnLayout() throws ColumnLayoutStorageException {
        return new DefaultColumnLayoutImpl(this.defaultColumnLayout.getColumnLayoutItems());
    }

    public EditableDefaultColumnLayout getEditableDefaultColumnLayout() {
        CacheableColumnLayout defaultColumnLayout = this.getUserColumnLayout(null);
        List<ColumnLayoutItem> columnLayoutItems = this.removeUnavailableColumnLayoutItems(defaultColumnLayout.columnLayoutItems);
        return new EditableDefaultColumnLayoutImpl((List)columnLayoutItems);
    }

    public EditableUserColumnLayout getEditableUserColumnLayout(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        CacheableColumnLayout columnLayout = this.getUserColumnLayout(user.getName());
        List<ColumnLayoutItem> columnLayoutItems = this.removeUnavailableColumnLayoutItemsForUser(columnLayout.columnLayoutItems, user);
        return new EditableUserColumnLayoutImpl(columnLayoutItems, user, columnLayout.columnConfig);
    }

    public void storeEditableDefaultColumnLayout(EditableDefaultColumnLayout editableDefaultColumnLayout) throws ColumnLayoutStorageException {
        this.storeEditableColumnLayout((ColumnLayout)editableDefaultColumnLayout, null);
        this.userColumnLayoutCache.removeAll();
    }

    public void storeEditableUserColumnLayout(EditableUserColumnLayout editableUserColumnLayout) throws ColumnLayoutStorageException {
        String userName = editableUserColumnLayout.getUser().getName();
        String userKey = (String)Assertions.notNull((String)"userKey", (Object)this.userKeyService.getKeyForUsername(userName));
        this.storeEditableColumnLayout((ColumnLayout)editableUserColumnLayout, userKey);
        this.userColumnLayoutCache.remove(CacheObject.wrap(userKey));
    }

    public void restoreDefaultColumnLayout() {
        this.restoreColumnLayout(null, null);
        this.userColumnLayoutCache.removeAll();
    }

    public void restoreUserColumnLayout(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        String userKey = this.userKeyService.getKeyForUser(user);
        if (userKey == null) {
            log.warn("Unable to restore column layout for nonexistant user '" + user.getName() + '\'');
            return;
        }
        this.restoreColumnLayout(userKey, user.getName());
        this.userColumnLayoutCache.remove(CacheObject.wrap(userKey));
    }

    public ColumnLayout getColumnLayout(ApplicationUser remoteUser, SearchRequest searchRequest) throws ColumnLayoutStorageException {
        String username = remoteUser == null ? null : remoteUser.getName();
        CacheableColumnLayout cols = this.getFilterColumnLayoutItems(username, searchRequest);
        List<ColumnLayoutItem> columnLayoutItems = this.removeUnavailableColumnLayoutItemsForUser(cols.columnLayoutItems, remoteUser);
        return new UserColumnLayoutImpl(columnLayoutItems, remoteUser, cols.columnConfig);
    }

    public EditableSearchRequestColumnLayout getEditableSearchRequestColumnLayout(ApplicationUser user, SearchRequest searchRequest) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        CacheableColumnLayout cols = this.getFilterColumnLayoutItems(user.getName(), searchRequest);
        List<ColumnLayoutItem> columnLayoutItems = this.removeUnavailableColumnLayoutItemsForUser(cols.columnLayoutItems, user);
        return new EditableSearchRequestColumnLayoutImpl(columnLayoutItems, user, searchRequest, cols.columnConfig);
    }

    public void storeEditableSearchRequestColumnLayout(EditableSearchRequestColumnLayout editableSearchRequestColumnLayout) {
        Long filterId = editableSearchRequestColumnLayout.getSearchRequest().getId();
        this.storeFilterColumnLayout((ColumnLayout)editableSearchRequestColumnLayout, filterId);
        this.filterColumnLayoutCache.remove((Object)filterId);
    }

    public void restoreSearchRequestColumnLayout(SearchRequest searchRequest) throws ColumnLayoutStorageException {
        this.resetFilterColumnLayout(searchRequest.getId());
        this.filterColumnLayoutCache.remove((Object)searchRequest.getId());
    }

    public boolean hasColumnLayout(SearchRequest searchRequest) {
        return this.hasColumnLayout(searchRequest.getId());
    }

    public boolean hasColumnLayout(Long filterId) {
        if (null == filterId) {
            return false;
        }
        CacheObject filterColumnLayout = (CacheObject)this.filterColumnLayoutCache.get((Object)filterId);
        return filterColumnLayout.hasValue();
    }

    public boolean hasColumnLayout(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        return this.hasDefaultColumnLayout(user);
    }

    public boolean hasDefaultColumnLayout() throws ColumnLayoutStorageException {
        return this.hasDefaultColumnLayout(null);
    }

    private boolean hasDefaultColumnLayout(ApplicationUser user) {
        String username = user != null ? user.getName() : null;
        String userKey = this.userKeyService.getKeyForUsername(username);
        return this.fetchUserColumnLayout(userKey) != null;
    }

    private CacheableColumnLayout getUserColumnLayout(String username) {
        String userKey = this.userKeyService.getKeyForUsername(username);
        return (CacheableColumnLayout)this.userColumnLayoutCache.get(CacheObject.wrap(userKey));
    }

    private synchronized void storeEditableColumnLayout(ColumnLayout columnLayout, String userKey) {
        try {
            GenericValue columnLayoutGV = this.fetchUserColumnLayout(userKey);
            if (columnLayoutGV == null) {
                columnLayoutGV = EntityUtils.createValue("ColumnLayout", MapBuilder.build((Object)"username", (Object)userKey, (Object)"searchrequest", null));
            }
            this.storeColumnLayoutItems(columnLayoutGV, columnLayout);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Could not load ColumnLayout", (Throwable)e);
        }
    }

    private void storeColumnLayoutItems(GenericValue columnLayoutGV, ColumnLayout columnLayout) throws GenericEntityException {
        List columnLayoutItemGVs = this.ofBizDelegator.getRelated("ChildColumnLayoutItem", columnLayoutGV);
        this.ofBizDelegator.removeAll(columnLayoutItemGVs);
        List columnLayoutItems = columnLayout.getColumnLayoutItems();
        for (int i = 0; i < columnLayoutItems.size(); ++i) {
            ColumnLayoutItem columnLayoutItem = (ColumnLayoutItem)columnLayoutItems.get(i);
            EntityUtils.createValue("ColumnLayoutItem", MapBuilder.build((Object)"columnlayout", (Object)columnLayoutGV.getLong("id"), (Object)"fieldidentifier", (Object)columnLayoutItem.getId(), (Object)"horizontalposition", (Object)new Long(i)));
        }
    }

    private synchronized void restoreColumnLayout(String userKey, String username) {
        try {
            GenericValue columnLayoutGV = this.fetchUserColumnLayout(userKey);
            if (columnLayoutGV != null) {
                this.removeColumnLayoutItems(columnLayoutGV);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error removing column layout for username " + username + ".", (Throwable)e);
        }
    }

    private GenericValue fetchUserColumnLayout(String userKey) {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", (Map)FieldMap.build((String)"username", (Object)userKey, (String)"searchrequest", null)));
    }

    private void removeColumnLayoutItems(GenericValue columnLayoutGV) throws GenericEntityException {
        List columnLayoutItemGVs = this.ofBizDelegator.getRelated("ChildColumnLayoutItem", columnLayoutGV);
        this.ofBizDelegator.removeAll(columnLayoutItemGVs);
        this.ofBizDelegator.removeValue(columnLayoutGV);
    }

    private CacheableColumnLayout getFilterColumnLayoutItems(String username, SearchRequest searchRequest) {
        CacheObject filterColumnLayout = (CacheObject)this.filterColumnLayoutCache.get((Object)searchRequest.getId());
        if (filterColumnLayout.hasValue()) {
            return (CacheableColumnLayout)filterColumnLayout.getValue();
        }
        return this.getUserColumnLayout(username);
    }

    private void storeFilterColumnLayout(ColumnLayout columnLayout, Long filterId) {
        try {
            GenericValue columnLayoutGV = this.fetchFilterColumnLayout(filterId);
            if (columnLayoutGV == null) {
                columnLayoutGV = EntityUtils.createValue("ColumnLayout", MapBuilder.build((Object)"username", null, (Object)"searchrequest", (Object)filterId));
            }
            this.storeColumnLayoutItems(columnLayoutGV, columnLayout);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Could not load ColumnLayout", (Throwable)e);
        }
    }

    private GenericValue fetchFilterColumnLayout(Long filterId) {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", (Map)FieldMap.build((String)"username", null, (String)"searchrequest", (Object)filterId)));
    }

    private void resetFilterColumnLayout(Long filterId) {
        try {
            GenericValue columnLayoutGV = this.fetchFilterColumnLayout(filterId);
            if (columnLayoutGV != null) {
                this.removeColumnLayoutItems(columnLayoutGV);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error removing column layout for search request with id  '" + filterId + "'.", (Throwable)e);
        }
    }

    private List<ColumnLayoutItem> removeUnavailableColumnLayoutItems(List<ColumnLayoutItem> columnLayoutItems) {
        try {
            return Lists.newArrayList((Iterable)Iterables.filter(columnLayoutItems, (Predicate)new IsAvailableFieldPredicate(this.fieldManager.getAllAvailableNavigableFields())));
        }
        catch (FieldException e) {
            throw new DataAccessException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    private List<ColumnLayoutItem> removeUnavailableColumnLayoutItemsForUser(List<ColumnLayoutItem> columnLayoutItems, ApplicationUser user) {
        try {
            return Lists.newArrayList((Iterable)Iterables.filter(columnLayoutItems, (Predicate)new IsAvailableFieldPredicate(this.fieldManager.getAvailableNavigableFields(user))));
        }
        catch (FieldException e) {
            throw new DataAccessException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    private List<ColumnLayoutItem> transformToColumnLayoutItems(GenericValue columnLayoutGV) {
        List columnLayoutItemGVs = this.ofBizDelegator.getRelated("ChildColumnLayoutItem", columnLayoutGV, (List)ImmutableList.of((Object)"horizontalposition ASC"));
        ArrayList columnLayoutItems = Lists.newArrayListWithCapacity((int)columnLayoutItemGVs.size());
        for (GenericValue columnLayoutItemGV : columnLayoutItemGVs) {
            if (!this.fieldManager.isNavigableField(columnLayoutItemGV.getString("fieldidentifier"))) continue;
            NavigableField navigableField = this.fieldManager.getNavigableField(columnLayoutItemGV.getString("fieldidentifier"));
            columnLayoutItems.add(new ColumnLayoutItemImpl(navigableField, columnLayoutItemGV.getLong("horizontalposition").intValue()));
        }
        return columnLayoutItems;
    }

    private class FilterColumnLayoutCacheLoader
    implements CacheLoader<Long, CacheObject<CacheableColumnLayout>> {
        private FilterColumnLayoutCacheLoader() {
        }

        public CacheObject<CacheableColumnLayout> load(@Nonnull Long filterId) {
            GenericValue columnLayoutGV = DefaultColumnLayoutManager.this.fetchFilterColumnLayout(filterId);
            if (columnLayoutGV != null) {
                return CacheObject.wrap(new CacheableColumnLayout(ColumnLayout.ColumnConfig.FILTER, DefaultColumnLayoutManager.this.transformToColumnLayoutItems(columnLayoutGV)));
            }
            return CacheObject.NULL();
        }
    }

    private class UserColumnLayoutCacheLoader
    implements CacheLoader<CacheObject<String>, CacheableColumnLayout> {
        private UserColumnLayoutCacheLoader() {
        }

        public CacheableColumnLayout load(@Nonnull CacheObject<String> userKey) {
            GenericValue columnLayoutGV;
            GenericValue genericValue = columnLayoutGV = userKey.hasValue() ? DefaultColumnLayoutManager.this.fetchUserColumnLayout(userKey.getValue()) : null;
            if (columnLayoutGV == null && (columnLayoutGV = DefaultColumnLayoutManager.this.fetchUserColumnLayout(null)) == null) {
                return new CacheableColumnLayout(ColumnLayout.ColumnConfig.SYSTEM, DefaultColumnLayoutManager.this.defaultColumnLayout.getColumnLayoutItems());
            }
            List columnLayoutItems = DefaultColumnLayoutManager.this.transformToColumnLayoutItems(columnLayoutGV);
            return new CacheableColumnLayout(ColumnLayout.ColumnConfig.USER, columnLayoutItems);
        }
    }

    private static final class CacheableColumnLayout {
        private final ColumnLayout.ColumnConfig columnConfig;
        private final List<ColumnLayoutItem> columnLayoutItems;

        private CacheableColumnLayout(ColumnLayout.ColumnConfig columnConfig, List<ColumnLayoutItem> columnLayoutItems) {
            this.columnConfig = columnConfig;
            this.columnLayoutItems = columnLayoutItems;
        }
    }

    private static class IsAvailableFieldPredicate
    implements Predicate<ColumnLayoutItem> {
        private final Set<NavigableField> availableFields;

        private IsAvailableFieldPredicate(Set<NavigableField> availableFields) {
            this.availableFields = availableFields;
        }

        public boolean apply(@Nullable ColumnLayoutItem input) {
            return input != null && this.availableFields.contains(input.getNavigableField());
        }
    }
}

