/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.customfields.manager.DefaultOptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachedOptionsManager
extends DefaultOptionsManager {
    private final CachedReference<List<Option>> allCache;
    private final Cache<Long, CacheObject<Options>> optionsCache;
    private final Cache<Long, CacheObject<Option>> optionCache;
    private final Cache<Long, List<Option>> parentCache;
    private final Cache<String, List<Option>> valueCache;

    public CachedOptionsManager(OfBizDelegator delegator, FieldConfigManager fieldConfigManager, CacheManager cacheManager) {
        super(delegator, fieldConfigManager);
        this.allCache = cacheManager.getCachedReference(CachedOptionsManager.class, "allCache", (Supplier)new AllOptionsSupplier());
        this.optionsCache = cacheManager.getCache(CachedOptionsManager.class.getName() + ".optionsCache", (CacheLoader)new OptionsCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.optionCache = cacheManager.getCache(CachedOptionsManager.class.getName() + ".optionCache", (CacheLoader)new OptionCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.parentCache = cacheManager.getCache(CachedOptionsManager.class.getName() + ".parentCache", (CacheLoader)new ParentCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.valueCache = cacheManager.getCache(CachedOptionsManager.class.getName() + ".valueCache", (CacheLoader)new ValueCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.init();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.init();
    }

    private void init() {
        this.optionsCache.removeAll();
        this.optionCache.removeAll();
        this.parentCache.removeAll();
        this.valueCache.removeAll();
        this.allCache.reset();
    }

    @Override
    public List<Option> getAllOptions() {
        return (List)this.allCache.get();
    }

    @Override
    public List<Option> findByOptionValue(String value) {
        if (value == null) {
            return null;
        }
        value = CaseFolding.foldString((String)value);
        return (List)this.valueCache.get((Object)value);
    }

    @Override
    public Options getOptions(FieldConfig fieldConfig) {
        Long key;
        Long l = key = fieldConfig == null ? null : fieldConfig.getId();
        if (key == null) {
            return super.getOptions(fieldConfig);
        }
        return (Options)((CacheObject)this.optionsCache.get((Object)fieldConfig.getId())).getValue();
    }

    @Override
    public void setRootOptions(FieldConfig fieldConfig, Options options) {
        super.setRootOptions(fieldConfig, options);
        this.init();
    }

    @Override
    public void removeCustomFieldOptions(CustomField customField) {
        super.removeCustomFieldOptions(customField);
        this.init();
    }

    @Override
    public void removeCustomFieldConfigOptions(FieldConfig fieldConfig) {
        super.removeCustomFieldConfigOptions(fieldConfig);
        this.init();
    }

    @Override
    public void updateOptions(Collection<Option> options) {
        super.updateOptions(options);
        for (Option option : options) {
            this.removeOptionFromCaches(option);
        }
        this.optionsCache.removeAll();
        this.allCache.reset();
    }

    @Override
    public Option createOption(FieldConfig fieldConfig, Long parentOptionId, Long sequence, String value) {
        Option option = super.createOption(fieldConfig, parentOptionId, sequence, value);
        this.removeOptionFromCaches(option);
        this.optionsCache.removeAll();
        this.allCache.reset();
        return option;
    }

    @Override
    public void deleteOptionAndChildren(Option option) {
        super.deleteOptionAndChildren(option);
        this.init();
    }

    @Override
    public void setValue(Option option, String value) {
        String oldValue = option.getValue();
        super.setValue(option, value);
        this.removeOptionFromCaches(option);
        if (option.getValue() != null) {
            this.valueCache.remove((Object)CaseFolding.foldString((String)oldValue));
        }
        if (option.getValue() != null) {
            this.valueCache.remove((Object)CaseFolding.foldString((String)value));
        }
        this.optionsCache.removeAll();
        this.allCache.reset();
    }

    @Override
    public void disableOption(Option option) {
        super.disableOption(option);
        this.removeOptionFromCaches(option);
        this.optionsCache.removeAll();
        this.allCache.reset();
    }

    @Override
    public void enableOption(Option option) {
        super.enableOption(option);
        this.removeOptionFromCaches(option);
        this.optionsCache.removeAll();
        this.allCache.reset();
    }

    private void removeOptionFromCaches(Option option) {
        this.optionCache.remove((Object)option.getOptionId());
        if (option.getValue() != null) {
            this.valueCache.remove((Object)CaseFolding.foldString((String)option.getValue()));
        }
        if (option.getParentOption() != null) {
            this.parentCache.remove((Object)option.getParentOption().getOptionId());
        }
    }

    @Override
    public Option findByOptionId(Long optionId) {
        if (optionId == null) {
            return null;
        }
        return (Option)((CacheObject)this.optionCache.get((Object)optionId)).getValue();
    }

    @Override
    public List<Option> findByParentId(Long parentOptionId) {
        return (List)this.parentCache.get((Object)parentOptionId);
    }

    private class ValueCacheLoader
    implements CacheLoader<String, List<Option>> {
        private ValueCacheLoader() {
        }

        public List<Option> load(@Nonnull String value) {
            return ImmutableList.copyOf((Collection)CachedOptionsManager.super.findByOptionValue(value));
        }
    }

    private class ParentCacheLoader
    implements CacheLoader<Long, List<Option>> {
        private ParentCacheLoader() {
        }

        public List<Option> load(@Nonnull Long id) {
            return ImmutableList.copyOf((Collection)CachedOptionsManager.super.findByParentId(id));
        }
    }

    private class OptionCacheLoader
    implements CacheLoader<Long, CacheObject<Option>> {
        private OptionCacheLoader() {
        }

        public CacheObject<Option> load(@Nonnull Long id) {
            return CacheObject.wrap(CachedOptionsManager.super.findByOptionId(id));
        }
    }

    private class AllOptionsSupplier
    implements Supplier<List<Option>> {
        private AllOptionsSupplier() {
        }

        public List<Option> get() {
            return ImmutableList.copyOf((Collection)CachedOptionsManager.super.getAllOptions());
        }
    }

    private class OptionsCacheLoader
    implements CacheLoader<Long, CacheObject<Options>> {
        private OptionsCacheLoader() {
        }

        public CacheObject<Options> load(@Nonnull Long fieldConfigId) {
            FieldConfig fieldConfig = CachedOptionsManager.this.fieldConfigManager.getFieldConfig(fieldConfigId);
            return CacheObject.wrap(CachedOptionsManager.super.getOptions(fieldConfig));
        }
    }
}

