/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import org.apache.commons.lang.StringUtils;

public class DefaultCommentPermissionManager
implements CommentPermissionManager {
    private final ProjectRoleManager projectRoleManager;
    private final PermissionManager permissionManager;
    private final GroupManager groupManager;

    public DefaultCommentPermissionManager(ProjectRoleManager projectRoleManager, PermissionManager permissionManager, GroupManager groupManager) {
        this.projectRoleManager = projectRoleManager;
        this.permissionManager = permissionManager;
        this.groupManager = groupManager;
    }

    public boolean hasBrowsePermission(ApplicationUser user, Comment comment) {
        String groupLevel = comment.getGroupLevel();
        Long roleLevel = comment.getRoleLevelId();
        boolean roleProvided = roleLevel != null;
        boolean groupProvided = StringUtils.isNotBlank((String)groupLevel);
        boolean userInRole = roleProvided && this.isUserInRole(roleLevel, user, comment.getIssue());
        boolean userInGroup = groupProvided && this.isUserInGroup(user, groupLevel);
        boolean noLevelsProvided = !groupProvided && !roleProvided;
        return noLevelsProvided || userInRole || userInGroup;
    }

    public boolean hasEditPermission(ApplicationUser user, Comment comment) {
        return this.hasEditAllPermission(user, comment.getIssue()) || this.hasEditOwnPermission(user, comment.getIssue()) && this.isUserCommentAuthor(user, comment);
    }

    public boolean isUserCommentAuthor(ApplicationUser user, Comment comment) {
        ApplicationUser commentAuthor = comment.getAuthorApplicationUser();
        if (commentAuthor == null) {
            return false;
        }
        if (Users.isAnonymous((ApplicationUser)user)) {
            return false;
        }
        return commentAuthor.equals((Object)user);
    }

    public boolean hasEditAllPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(34, issue, user);
    }

    public boolean hasEditOwnPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(35, issue, user);
    }

    public boolean hasDeleteAllPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(36, issue, user);
    }

    public boolean hasDeleteOwnPermission(ApplicationUser user, Issue issue) {
        return this.permissionManager.hasPermission(37, issue, user);
    }

    private boolean isUserInGroup(ApplicationUser user, String groupname) {
        if (user == null) {
            return false;
        }
        Group group = this.groupManager.getGroup(groupname);
        return group != null && this.groupManager.isUserInGroup(user == null ? null : user, group);
    }

    private boolean isUserInRole(Long roleLevel, ApplicationUser user, Issue issue) {
        boolean isUserInRole = false;
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleLevel);
        if (projectRole != null) {
            isUserInRole = this.projectRoleManager.isUserInProjectRole(user, projectRole, issue.getProjectObject());
        }
        return isUserInRole;
    }
}

