/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalLink;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.IssueLinkParser;
import com.atlassian.jira.imports.project.transformer.IssueLinkTransformer;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueLinkPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(IssueLinkPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private final ApplicationUser importAuthor;
    private final IssueLinkTransformer issueLinkTransformer;
    private final IssueLinkParser issueLinkParser;

    public IssueLinkPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, IssueLinkTransformer issueLinkTransformer, IssueLinkParser issueLinkParser, Executor executor, ApplicationUser importAuthor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
        this.importAuthor = importAuthor;
        this.issueLinkTransformer = issueLinkTransformer;
        this.issueLinkParser = issueLinkParser;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("IssueLink".equals(entityName)) {
            ExternalLink externalIssueLink = this.issueLinkParser.parse(attributes);
            if (externalIssueLink.getSourceId() == null || externalIssueLink.getDestinationId() == null) {
                log.warn("Ignoring Issue Link id='" + externalIssueLink.getId() + "'; the source or destination is missing.");
                return;
            }
            ExternalLink transformedIssueLink = this.issueLinkTransformer.transform(this.projectImportMapper, externalIssueLink);
            if (transformedIssueLink != null) {
                this.execute(() -> {
                    Long linkId = this.projectImportPersister.createEntity(this.issueLinkParser.getEntityRepresentation(transformedIssueLink));
                    if (linkId == null) {
                        String sourceKey = this.backupSystemInformation.getIssueKeyForId(externalIssueLink.getSourceId());
                        String destKey = this.backupSystemInformation.getIssueKeyForId(externalIssueLink.getDestinationId());
                        this.projectImportResults.addError(this.projectImportResults.getI18n().getText("admin.errors.project.import.issue.link.error", sourceKey, destKey));
                    } else {
                        boolean sourceOutsideProject = this.issueIsOutsideCurrentProject(externalIssueLink.getSourceId());
                        boolean destOutsideProject = this.issueIsOutsideCurrentProject(externalIssueLink.getDestinationId());
                        if (sourceOutsideProject || destOutsideProject) {
                            String issueId = sourceOutsideProject ? transformedIssueLink.getSourceId() : transformedIssueLink.getDestinationId();
                            SimpleProjectImportIdMapper issueMapper = this.projectImportMapper.getIssueMapper();
                            String inProjectIssueKey = sourceOutsideProject ? this.backupSystemInformation.getIssueKeyForId(externalIssueLink.getDestinationId()) : this.backupSystemInformation.getIssueKeyForId(externalIssueLink.getSourceId());
                            String issueKeyToReindex = this.projectImportPersister.createChangeItemForIssueLinkIfNeeded(issueId, transformedIssueLink.getLinkType(), inProjectIssueKey, sourceOutsideProject, this.importAuthor);
                            if (issueKeyToReindex != null) {
                                issueMapper.mapValue(issueKeyToReindex, issueKeyToReindex);
                            }
                        }
                    }
                });
            }
        }
    }

    boolean issueIsOutsideCurrentProject(String issueId) {
        SimpleProjectImportIdMapper issueMapper = this.projectImportMapper.getIssueMapper();
        return issueMapper.getMappedId(issueId) == null;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

