/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;

public class SupportedCollations {
    private static final Collection<String> supportedOracleCollations = Sets.newHashSet((Object[])new String[]{"BINARY"});
    private static final Collection<String> supportedMySqlCollations = Sets.newHashSet((Object[])new String[]{"utf8_bin"});
    private static final Collection<String> supportedPostgresCollations = Sets.newHashSet((Object[])new String[]{"C", "POSIX"});
    private static final Collection<String> supportedSqlServerCollations = Sets.newHashSet((Object[])new String[]{"SQL_Latin1_General_CP437_CI_AI", "SQL_Latin1_General_CI_AI"});

    public static boolean isSupported(DatabaseConfig databaseConfig, String collation) {
        if (databaseConfig.isHSql() || databaseConfig.isH2()) {
            return true;
        }
        Collection<String> supportedCollations = SupportedCollations.forDatabase(databaseConfig);
        return supportedCollations.contains(collation);
    }

    public static Collection<String> forDatabase(DatabaseConfig databaseConfig) {
        if (databaseConfig.isOracle()) {
            return supportedOracleCollations;
        }
        if (databaseConfig.isMySql()) {
            return supportedMySqlCollations;
        }
        if (databaseConfig.isPostgres()) {
            return supportedPostgresCollations;
        }
        if (databaseConfig.isSqlServer()) {
            return supportedSqlServerCollations;
        }
        return new HashSet<String>();
    }
}

