/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUserCache;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.map.CacheObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

class LazyOfBizUserCache
implements OfBizUserCache {
    private final Cache<DirectoryEntityKey, CacheObject<OfBizUser>> cache;
    private OfBizDelegator ofBizDelegator;

    public LazyOfBizUserCache(CacheManager cacheManager, OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
        this.cache = cacheManager.getCache(LazyOfBizUserCache.class.getName() + ".userCache", (CacheLoader)new UserCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
    }

    @Override
    public boolean isCacheInitialized() {
        return true;
    }

    @Override
    public void refresh() {
        this.cache.removeAll();
    }

    @Override
    public void visitAllUserIdsInDirectory(long directoryId, Visitor<String> visitor) {
        Select.stringColumn("externalId").from("User").whereEqual("directoryId", directoryId).runWith(this.ofBizDelegator).visitWith(visitor);
    }

    @Override
    public OfBizUser getCaseInsensitive(long directoryId, String name) {
        CacheObject cacheValue = (CacheObject)this.cache.get((Object)DirectoryEntityKey.getKeyLowerCase(directoryId, name));
        if (cacheValue == null) {
            return null;
        }
        return (OfBizUser)cacheValue.getValue();
    }

    @Override
    public List<OfBizUser> getAllCaseInsensitive(long directoryId, Collection<String> userIds) {
        ArrayList<OfBizUser> users = new ArrayList<OfBizUser>(userIds.size());
        int batchSize = 500;
        ArrayList<String> userIdBatch = new ArrayList<String>(500);
        for (String userId : userIds) {
            userIdBatch.add(userId);
            if (userIdBatch.size() != 500) continue;
            this.readUsers(directoryId, userIdBatch, users);
            userIdBatch.clear();
        }
        if (!userIdBatch.isEmpty()) {
            this.readUsers(directoryId, userIdBatch, users);
        }
        return users;
    }

    @Override
    public DirectoryEntityKey refresh(OfBizUser user) {
        DirectoryEntityKey key = DirectoryEntityKey.getKeyLowerCase(user);
        this.cache.remove((Object)key);
        return key;
    }

    @Override
    public void remove(long directoryId, String name) {
        this.cache.remove((Object)DirectoryEntityKey.getKeyLowerCase(directoryId, name));
    }

    @Override
    public void remove(DirectoryEntityKey key) {
        this.cache.remove((Object)key);
    }

    private void readUsers(long directoryId, List<String> userNames, final List<OfBizUser> readIntoList) {
        Select.from("User").whereEqual("directoryId", directoryId).andCondition((EntityCondition)new EntityExpr("lowerUserName", EntityOperator.IN, userNames)).runWith(this.ofBizDelegator).visitWith(new Visitor<GenericValue>(){

            public void visit(GenericValue element) {
                readIntoList.add(OfBizUser.from(element));
            }
        });
    }

    private class UserCacheLoader
    implements CacheLoader<DirectoryEntityKey, CacheObject<OfBizUser>> {
        private UserCacheLoader() {
        }

        @Nonnull
        public CacheObject<OfBizUser> load(@Nonnull DirectoryEntityKey key) {
            GenericValue user = (GenericValue)Select.columns(OfBizUser.SUPPORTED_FIELDS).from("User").whereEqual("directoryId", key.getDirectoryId()).andEqual("lowerUserName", key.getName()).runWith(LazyOfBizUserCache.this.ofBizDelegator).singleValue();
            if (user == null) {
                return CacheObject.NULL();
            }
            return CacheObject.wrap(OfBizUser.from(user));
        }
    }
}

