/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.jira.bc.user.search.AssigneeService;
import com.atlassian.jira.bc.user.search.UserMatcherPredicate;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.UserSet;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultAssigneeService
implements AssigneeService {
    private final PermissionContextFactory permissionContextFactory;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final UserHistoryManager userHistoryManager;
    private ChangeHistoryManager changeHistoryManager;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext authenticationContext;
    private final UserKeyService userKeyService;
    private final UserManager userManager;

    public DefaultAssigneeService(PermissionContextFactory permissionContextFactory, PermissionSchemeManager permissionSchemeManager, UserHistoryManager userHistoryManager, FeatureManager featureManager, JiraAuthenticationContext authenticationContext, UserKeyService userKeyService, UserManager userManager, PermissionManager permissionManager) {
        this.permissionContextFactory = permissionContextFactory;
        this.permissionSchemeManager = permissionSchemeManager;
        this.userHistoryManager = userHistoryManager;
        this.featureManager = featureManager;
        this.authenticationContext = authenticationContext;
        this.userKeyService = userKeyService;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
    }

    public boolean isAssignable(@Nonnull Issue issue, @Nonnull ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        return this.permissionManager.hasPermission(ProjectPermissions.ASSIGNABLE_USER, issue, user);
    }

    public boolean isAssignable(@Nonnull Project project, @Nonnull ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.ASSIGNABLE_USER, project, user);
    }

    public List<ApplicationUser> getSuggestedAssignees(Issue issue, @Nullable ApplicationUser loggedInUser, @Nullable ActionDescriptor actionDescriptor) {
        ApplicationUser currentAssignee;
        ArrayList<ApplicationUser> suggestedAssignees = new ArrayList<ApplicationUser>();
        Set<String> suggestedAssigneeKeys = this.getSuggestedAssigneeKeys(issue, loggedInUser);
        for (String suggestedAssigneeKey : suggestedAssigneeKeys) {
            ApplicationUser appUser = this.userManager.getUserByKey(suggestedAssigneeKey);
            if (appUser == null || !this.isAssignable(issue, appUser, actionDescriptor)) continue;
            suggestedAssignees.add(appUser);
        }
        if (issue != null && issue.getAssignee() != null && !suggestedAssignees.contains(currentAssignee = issue.getAssignee())) {
            suggestedAssignees.add(issue.getAssignee());
        }
        Collections.sort(suggestedAssignees, new UserCachingComparator(this.authenticationContext.getLocale()));
        return suggestedAssignees;
    }

    public List<ApplicationUser> getSuggestedAssignees(Issue issue, ApplicationUser loggedInUser, List<ApplicationUser> assignableUsers) {
        Set<String> suggestedAssigneeKeys = this.getSuggestedAssigneeKeys(issue, loggedInUser);
        return this.getSuggestedAssigneesFromKeys(suggestedAssigneeKeys, assignableUsers);
    }

    public Collection<ApplicationUser> findAssignableUsers(String query, Issue issue, @Nullable ActionDescriptor actionDescriptor) {
        return new AssignableUsers(issue, actionDescriptor).matchingUsername(query).findAllAndSort();
    }

    public Collection<ApplicationUser> findAssignableUsers(String query, Project project) {
        return new AssignableUsers(project).matchingUsername(query).findAllAndSort();
    }

    private Set<ApplicationUser> findAssignableUsers(String query, Set<ApplicationUser> assignableUsers) {
        String convertedQuery;
        String string = convertedQuery = query == null ? "" : query.trim().toLowerCase();
        if (StringUtils.isBlank((String)query)) {
            return assignableUsers;
        }
        HashSet<ApplicationUser> returnUsers = new HashSet<ApplicationUser>();
        UserMatcherPredicate userMatcher = new UserMatcherPredicate(convertedQuery, true);
        for (ApplicationUser user : assignableUsers) {
            if (!userMatcher.apply(user)) continue;
            returnUsers.add(user);
        }
        return returnUsers;
    }

    private Set<String> getSuggestedAssigneeKeys(Issue issue, ApplicationUser loggedInUser) {
        ApplicationUser reporter;
        HashSet<String> suggestedAssignees = new HashSet<String>();
        if (loggedInUser != null && this.useFrotherControl()) {
            suggestedAssignees.add(loggedInUser.getKey());
        }
        suggestedAssignees.addAll(this.getRecentAssigneeKeysForIssue(issue));
        suggestedAssignees.addAll(this.getRecentAssigneeKeysForUser(loggedInUser));
        ApplicationUser applicationUser = reporter = issue == null ? null : issue.getReporter();
        if (reporter != null) {
            suggestedAssignees.add(reporter.getKey());
        }
        return suggestedAssignees;
    }

    private boolean useFrotherControl() {
        boolean on = this.featureManager.isEnabled("frother.assignee.field");
        boolean off = this.featureManager.isEnabled("no.frother.assignee.field");
        return on && !off;
    }

    private List<ApplicationUser> getSuggestedAssigneesFromKeys(Set<String> suggestedAssigneeKeys, List<ApplicationUser> assignableUsers) {
        ArrayList<ApplicationUser> suggestedAssignees = new ArrayList<ApplicationUser>();
        if (!suggestedAssigneeKeys.isEmpty()) {
            for (ApplicationUser user : assignableUsers) {
                String key = user.getKey();
                if (!suggestedAssigneeKeys.remove(key)) continue;
                suggestedAssignees.add(user);
            }
        }
        return suggestedAssignees;
    }

    public List<ApplicationUser> getSuggestedAssignees(Set<String> suggestedAssigneeNames, List<ApplicationUser> assignableUsers) {
        ArrayList<ApplicationUser> suggestedAssignees = new ArrayList<ApplicationUser>();
        if (!suggestedAssigneeNames.isEmpty()) {
            for (ApplicationUser user : assignableUsers) {
                if (!suggestedAssigneeNames.remove(user.getName())) continue;
                suggestedAssignees.add(user);
            }
        }
        return suggestedAssignees;
    }

    public List<ApplicationUser> getAssignableUsers(Issue issue, ActionDescriptor actionDescriptor) {
        return new AssignableUsers(issue, actionDescriptor).findAllAndSort();
    }

    public List<ApplicationUser> getAssignableUsers(Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        if (issues == null) {
            return Collections.emptyList();
        }
        Iterator<Issue> iter = issues.iterator();
        if (!iter.hasNext()) {
            return Collections.emptyList();
        }
        Set<ApplicationUser> assignableUsers = new AssignableUsers(iter.next(), actionDescriptor).findAllAsSet();
        while (iter.hasNext() && !assignableUsers.isEmpty()) {
            assignableUsers.retainAll(new AssignableUsers(iter.next(), actionDescriptor).findAllAsSet());
        }
        ArrayList<ApplicationUser> sortedUsers = new ArrayList<ApplicationUser>(assignableUsers);
        Collections.sort(sortedUsers, new UserCachingComparator(this.authenticationContext.getLocale()));
        return sortedUsers;
    }

    public Set<String> getRecentAssigneeKeysForIssue(Issue issue) {
        String assigneeId;
        HashSet<String> recentAssignees = new HashSet<String>();
        List assigneeHistory = this.getChangeHistoryManager().getChangeItemsForField(issue, "assignee");
        Collections.sort(assigneeHistory, new Comparator<ChangeItemBean>(){

            @Override
            public int compare(ChangeItemBean changeItemBean1, ChangeItemBean changeItemBean2) {
                return changeItemBean2.getCreated().compareTo(changeItemBean1.getCreated());
            }
        });
        for (ChangeItemBean changeItemBean : assigneeHistory) {
            recentAssignees.add(changeItemBean.getTo());
            if (recentAssignees.size() < 5) continue;
            break;
        }
        if ((assigneeId = issue.getAssigneeId()) != null) {
            recentAssignees.add(assigneeId);
        }
        return recentAssignees;
    }

    public Set<String> getRecentAssigneeNamesForIssue(Issue issue) {
        HashSet results = Sets.newHashSet();
        for (String key : this.getRecentAssigneeKeysForIssue(issue)) {
            String username = this.userKeyService.getUsernameForKey(key);
            if (username == null) continue;
            results.add(username);
        }
        return results;
    }

    public Map<String, Boolean> makeUniqueFullNamesMap(Collection<ApplicationUser> users) {
        HashMap<String, Boolean> uniqueFullNames = new HashMap<String, Boolean>();
        for (ApplicationUser user : users) {
            String fullName = user.getDisplayName();
            Boolean isUnique = (Boolean)uniqueFullNames.get(fullName);
            if (isUnique == null) {
                uniqueFullNames.put(fullName, Boolean.TRUE);
                continue;
            }
            uniqueFullNames.put(fullName, Boolean.FALSE);
        }
        return uniqueFullNames;
    }

    public Set<String> getRecentAssigneeNamesForUser(ApplicationUser remoteUser) {
        HashSet results = Sets.newHashSet();
        for (String key : this.getRecentAssigneeKeysForUser(remoteUser)) {
            String userName = this.userKeyService.getUsernameForKey(key);
            if (userName == null) continue;
            results.add(userName);
        }
        return results;
    }

    public Set<String> getRecentAssigneeKeysForUser(ApplicationUser remoteUser) {
        ArrayList recentUserHistory = new ArrayList(this.userHistoryManager.getHistory(UserHistoryItem.ASSIGNEE, remoteUser));
        Collections.sort(recentUserHistory, new Comparator<UserHistoryItem>(){

            @Override
            public int compare(UserHistoryItem userHistoryItem1, UserHistoryItem userHistoryItem2) {
                return (int)(userHistoryItem2.getLastViewed() - userHistoryItem1.getLastViewed());
            }
        });
        HashSet<String> recentHistoryAssignees = new HashSet<String>();
        for (UserHistoryItem userHistoryItem : recentUserHistory) {
            recentHistoryAssignees.add(userHistoryItem.getEntityId());
            if (recentHistoryAssignees.size() < 5) continue;
            break;
        }
        return recentHistoryAssignees;
    }

    void setChangeHistoryManager(ChangeHistoryManager changeHistoryManager) {
        this.changeHistoryManager = changeHistoryManager;
    }

    private ChangeHistoryManager getChangeHistoryManager() {
        if (this.changeHistoryManager == null) {
            this.setChangeHistoryManager(ComponentAccessor.getChangeHistoryManager());
        }
        return this.changeHistoryManager;
    }

    final class AssignableUsers {
        private final Issue issue;
        private final PermissionContext ctx;
        private final String matchingUsername;

        AssignableUsers(Project project) {
            this.issue = null;
            this.ctx = DefaultAssigneeService.this.permissionContextFactory.getPermissionContext(project);
            this.matchingUsername = null;
        }

        AssignableUsers(Issue issue, ActionDescriptor actionDescriptor) {
            this.issue = issue;
            this.ctx = DefaultAssigneeService.this.permissionContextFactory.getPermissionContext(issue, actionDescriptor);
            this.matchingUsername = null;
        }

        AssignableUsers(Issue issue, PermissionContext ctx, String matchingUsername) {
            this.issue = issue;
            this.ctx = ctx;
            this.matchingUsername = matchingUsername;
        }

        public AssignableUsers matchingUsername(String matchingUsername) {
            return new AssignableUsers(this.issue, this.ctx, matchingUsername);
        }

        public List<ApplicationUser> findAll() {
            return Lists.newArrayList(this.findAllAsSet());
        }

        Set<ApplicationUser> findAllAsSet() {
            UserSet userSet = new UserSet(DefaultAssigneeService.this.permissionSchemeManager.getUsers(ProjectPermissions.ASSIGNABLE_USER, this.ctx));
            if (this.issue != null && this.issue.getAssignee() != null) {
                userSet.add(this.issue.getAssignee());
            }
            Set assignableUsers = userSet.toSet();
            if (this.matchingUsername != null) {
                assignableUsers = DefaultAssigneeService.this.findAssignableUsers(this.matchingUsername, assignableUsers);
            }
            return assignableUsers;
        }

        public List<ApplicationUser> findAllAndSort() {
            List<ApplicationUser> users = this.findAll();
            Collections.sort(users, new UserCachingComparator(DefaultAssigneeService.this.authenticationContext.getLocale()));
            return users;
        }
    }
}

