/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.index;

import com.atlassian.jira.config.IndexTask;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;

public class ProjectIndexTaskContext
implements IndexTask {
    private static final long serialVersionUID = -1875765202444481474L;
    private final Long projectId;
    private final String projectName;

    public ProjectIndexTaskContext(Project project) {
        this.projectId = project.getId();
        this.projectName = project.getName();
    }

    @Override
    public String getTaskInProgressMessage(I18nHelper i18n) {
        return i18n.getText("admin.notifications.reindex.in.progress.project", this.projectName);
    }

    @Override
    public String buildProgressURL(Long taskId) {
        return "/secure/project/IndexProjectProgress.jspa?pid=" + this.projectId + "&taskId=" + taskId;
    }

    public int hashCode() {
        return this.projectId.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ProjectIndexTaskContext && this.projectId.equals(((ProjectIndexTaskContext)obj).projectId);
    }
}

