/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.AllProjectsContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.context.QueryContextImpl;
import com.atlassian.jira.util.InjectableComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@InjectableComponent
public class QueryContextConverter {
    public QueryContext getQueryContext(SearchContext searchContext) {
        HashSet<ProjectIssueTypeContextImpl> contexts = new HashSet<ProjectIssueTypeContextImpl>();
        if (searchContext.isForAnyProjects() && searchContext.isForAnyIssueTypes()) {
            return new QueryContextImpl(ClauseContextImpl.createGlobalClauseContext());
        }
        if (searchContext.isForAnyProjects()) {
            for (String typeId : searchContext.getIssueTypeIds()) {
                contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)AllProjectsContext.INSTANCE, (IssueTypeContext)new IssueTypeContextImpl(typeId)));
            }
        } else if (searchContext.isForAnyIssueTypes()) {
            for (Long projId : searchContext.getProjectIds()) {
                contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(projId), (IssueTypeContext)AllIssueTypesContext.INSTANCE));
            }
        } else {
            for (Long projId : searchContext.getProjectIds()) {
                for (String typeId : searchContext.getIssueTypeIds()) {
                    contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(projId), (IssueTypeContext)new IssueTypeContextImpl(typeId)));
                }
            }
        }
        return new QueryContextImpl((ClauseContext)new ClauseContextImpl(contexts));
    }

    public SearchContext getSearchContext(QueryContext queryContext) {
        List<Long> projects = null;
        List<String> issueTypes = null;
        if (queryContext != null && (projects = this.getSearchContextProjects(queryContext)) != null) {
            issueTypes = this.getSearchContextIssueTypes(queryContext);
        }
        if (projects != null && issueTypes != null) {
            return this.createSearchContext(projects, issueTypes);
        }
        return null;
    }

    private List<String> getSearchContextIssueTypes(QueryContext queryContext) {
        HashSet typesPerProject = new HashSet();
        Collection contexts = queryContext.getProjectIssueTypeContexts();
        for (QueryContext.ProjectIssueTypeContexts context : contexts) {
            Collection issueTypeContexts = context.getIssueTypeContexts();
            LinkedHashSet<String> typesForProject = new LinkedHashSet<String>();
            for (IssueTypeContext issueTypeContext : issueTypeContexts) {
                typesForProject.add(issueTypeContext.getIssueTypeId());
            }
            typesPerProject.add(typesForProject);
        }
        if (typesPerProject.size() != 1) {
            return null;
        }
        Set types = (Set)typesPerProject.iterator().next();
        if (types.contains(null) && types.size() != 1) {
            return null;
        }
        if (types.contains(null)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(types);
    }

    private List<Long> getSearchContextProjects(QueryContext queryContext) {
        LinkedHashSet<Long> projects = new LinkedHashSet<Long>();
        Collection contexts = queryContext.getProjectIssueTypeContexts();
        for (QueryContext.ProjectIssueTypeContexts context : contexts) {
            Long project = context.getProjectContext().getProjectId();
            projects.add(project);
        }
        if (projects.contains(null) && projects.size() != 1) {
            return null;
        }
        if (projects.contains(null)) {
            return Collections.emptyList();
        }
        return new ArrayList<Long>(projects);
    }

    SearchContext createSearchContext(List<Long> projects, List<String> issueTypes) {
        return new SearchContextImpl(Collections.emptyList(), projects, issueTypes);
    }
}

