/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.jira.avatar.Selection;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.RenderedImage;
import org.j3d.util.ImageGenerator;

public class ImageScaler {
    public RenderedImage getSelectedImageData(BufferedImage sourceImage, Selection crop, int size) {
        if (crop == null) {
            crop = this.autoCalculateImageCropSelection(sourceImage.getWidth(), sourceImage.getHeight(), size);
        }
        CropImageFilter cropFilter = new CropImageFilter(crop.getTopLeftX(), crop.getTopLeftY(), crop.getWidth(), crop.getHeight());
        AreaAveragingScaleFilter scaleFilter = new AreaAveragingScaleFilter(size, size);
        FilteredImageSource croppedImageProducer = new FilteredImageSource(sourceImage.getSource(), cropFilter);
        FilteredImageSource croppedAndResizedImageProducer = new FilteredImageSource(croppedImageProducer, scaleFilter);
        ImageGenerator generator = new ImageGenerator();
        croppedAndResizedImageProducer.startProduction((ImageConsumer)generator);
        BufferedImage scaledImage = generator.getImage();
        scaledImage.flush();
        return scaledImage;
    }

    private Selection autoCalculateImageCropSelection(int imageWidth, int imageHeight, int targetSize) {
        if (imageWidth <= targetSize && imageHeight <= targetSize) {
            return new Selection(0, 0, imageWidth, imageHeight);
        }
        int largestSquareWidth = Math.min(imageWidth, imageHeight);
        int xOffset = (imageWidth - largestSquareWidth) / 2;
        int yOffset = (imageHeight - largestSquareWidth) / 2;
        return new Selection(xOffset, yOffset, largestSquareWidth, largestSquareWidth);
    }
}

