/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.annotations.Internal;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Option;
import com.atlassian.jira.CachingComponent;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.application.ApplicationRoleStore;
import com.atlassian.jira.application.DefinitionApplicationRole;
import com.atlassian.jira.application.IdApplicationRole;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public final class DefaultApplicationRoleManager
implements ApplicationRoleManager,
CachingComponent {
    private static final Logger log = LoggerFactory.getLogger(DefaultApplicationRoleManager.class);
    private final ApplicationRoleDefinitions definitions;
    private final GroupManager groupManager;
    private final ApplicationRoleStore applicationRoleStore;
    private final JiraLicenseManager licenseManager;
    private final RecoveryMode recoveryMode;
    private final FeatureManager featureManager;
    @ClusterSafe
    private final Cache<ApplicationKey, Option<ApplicationRole>> appRoleCache;
    @ClusterSafe
    private final Cache<ApplicationKey, Integer> activeUsersCountForLicense;

    public DefaultApplicationRoleManager(CacheManager cacheManager, ApplicationRoleStore store, ApplicationRoleDefinitions definitions, GroupManager groupManager, JiraLicenseManager licenseManager, FeatureManager featureManager, RecoveryMode recoveryMode) {
        Assertions.notNull((String)"cacheManager", (Object)cacheManager);
        this.recoveryMode = (RecoveryMode)Assertions.notNull((String)"recoveryMode", (Object)recoveryMode);
        this.groupManager = (GroupManager)Assertions.notNull((String)"groupManager", (Object)groupManager);
        this.applicationRoleStore = (ApplicationRoleStore)Assertions.notNull((String)"store", (Object)store);
        this.definitions = (ApplicationRoleDefinitions)Assertions.notNull((String)"definitions", (Object)definitions);
        this.licenseManager = (JiraLicenseManager)Assertions.notNull((String)"licenseManager", (Object)licenseManager);
        this.featureManager = (FeatureManager)Assertions.notNull((String)"featureManager", (Object)featureManager);
        this.appRoleCache = cacheManager.getCache(DefaultApplicationRoleManager.class.getName() + ".applicationRoleGroups", (CacheLoader)new RoleLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(100).build());
        this.activeUsersCountForLicense = cacheManager.getCache(DefaultApplicationRoleManager.class.getName() + ".activeUsersCountForLicense", (CacheLoader)new ActiveUserCountLoader(), new CacheSettingsBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build());
    }

    @Nonnull
    public Option<ApplicationRole> getRole(@Nonnull ApplicationKey role) {
        Assertions.notNull((String)"role", (Object)role);
        return (Option)this.appRoleCache.get((Object)role);
    }

    @Nonnull
    public Set<ApplicationRole> getRoles() {
        HashSet roles = Sets.newHashSet();
        for (ApplicationKey appKey : this.licenseManager.getAllLicensedApplicationKeys()) {
            Iterables.addAll((Collection)roles, this.getRole(appKey));
        }
        return Collections.unmodifiableSet(roles);
    }

    @Nonnull
    public Set<ApplicationRole> getDefaultRoles() {
        return (Set)this.getRoles().stream().filter(ApplicationRole::isSelectedByDefault).collect(CollectorsUtil.toImmutableSet());
    }

    @Nonnull
    public Set<ApplicationKey> getDefaultApplicationKeys() {
        return (Set)this.getDefaultRoles().stream().map(ApplicationRole::getKey).collect(CollectorsUtil.toImmutableSet());
    }

    public boolean hasAnyRole(@Nullable ApplicationUser user) {
        if (user == null) {
            return false;
        }
        Set<Group> roleGroups = this.getGroupsForLicensedRoles();
        for (Group userGroup : this.groupManager.getGroupsForUser(user)) {
            if (!roleGroups.contains(userGroup)) continue;
            return true;
        }
        return this.recoveryMode.isRecoveryUser(user);
    }

    public boolean isAnyRoleLimitExceeded() {
        if (!this.rolesEnabled()) {
            return this.legacyIsRoleLimitExceeded();
        }
        Set<ApplicationRole> roles = this.getRoles();
        if (roles.isEmpty()) {
            return true;
        }
        for (ApplicationRole role : roles) {
            if (!this.isRoleLimitExceeded(role.getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean isRoleLimitExceeded(@Nonnull ApplicationKey role) {
        int numGrantedSeats = this.getNumberOfSeatsGrantedToRole(role);
        if (numGrantedSeats == -1) {
            return false;
        }
        return this.getUserCount(role) > numGrantedSeats;
    }

    public boolean hasExceededAllRoles(@Nonnull ApplicationUser user) {
        Assertions.notNull((Object)user);
        if (!this.rolesEnabled()) {
            return this.legacyIsRoleLimitExceeded();
        }
        for (ApplicationRole role : this.getRolesForUser(user)) {
            if (this.isRoleLimitExceeded(role.getKey())) continue;
            return false;
        }
        return true;
    }

    public Set<ApplicationRole> getRolesForUser(@Nonnull ApplicationUser user) {
        Assertions.notNull((Object)user);
        Set<ApplicationRole> licensedRoles = this.getRoles();
        HashSet roles = Sets.newHashSetWithExpectedSize((int)licensedRoles.size());
        for (Group userGroup : this.groupManager.getGroupsForUser(user)) {
            roles.addAll(licensedRoles.stream().filter(role -> role.getGroups().contains(userGroup)).collect(Collectors.toList()));
        }
        return Collections.unmodifiableSet(roles);
    }

    public Set<ApplicationRole> getRolesForGroup(@Nonnull Group group) {
        Assertions.notNull((String)"group", (Object)group);
        return (Set)this.getRoles().stream().filter(role -> role.getGroups().contains(group)).collect(CollectorsUtil.toImmutableSet());
    }

    private boolean legacyIsRoleLimitExceeded() {
        if (this.featureManager.isOnDemand()) {
            return false;
        }
        int activeUsers = ((LicenseCountService)ComponentAccessor.getComponent(LicenseCountService.class)).totalBillableUsers();
        int maxUsers = ((LicenseDetails)this.licenseManager.getLicenses().iterator().next()).getJiraLicense().getMaximumNumberOfUsers();
        return maxUsers != -1 && activeUsers > maxUsers;
    }

    private int getNumberOfSeatsGrantedToRole(@Nonnull ApplicationKey roleKey) {
        int numSeats = 0;
        for (LicenseDetails license : this.licenseManager.getLicenses()) {
            int num = license.getLicensedApplications().getUserLimit(roleKey);
            if (num == 0) continue;
            if (numSeats != 0) {
                throw new IllegalStateException("Application role has users granted in > 1 license: " + roleKey);
            }
            numSeats = num;
        }
        return numSeats;
    }

    @Nonnull
    public Set<Group> getGroupsForLicensedRoles() {
        return (Set)this.getRoles().stream().map(ApplicationRole::getGroups).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    public void removeGroupFromRoles(@Nonnull Group group) {
        Assertions.notNull((String)"group", (Object)group);
        this.applicationRoleStore.removeGroup(group.getName());
        this.clearCache();
    }

    public boolean isRoleInstalledAndLicensed(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        return this.definitions.isDefined(key) && this.definitions.isLicensed(key);
    }

    @Nonnull
    public ApplicationRole setRole(@Nonnull ApplicationRole role) {
        this.validateRole((ApplicationRole)Assertions.notNull((String)"role", (Object)role));
        ApplicationKey key = role.getKey();
        try {
            this.applicationRoleStore.save(new ApplicationRoleStore.ApplicationRoleData(key, DefaultApplicationRoleManager.groupNames(role.getGroups()), DefaultApplicationRoleManager.groupNames(role.getDefaultGroups()), role.isSelectedByDefault()));
        }
        finally {
            this.clearCacheLine(key);
        }
        return (ApplicationRole)((Option)this.appRoleCache.get((Object)key)).getOrElse(() -> IdApplicationRole.empty(key));
    }

    public int getUserCount(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        return (Integer)this.activeUsersCountForLicense.get((Object)key);
    }

    public int getRemainingSeats(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        if (!this.rolesEnabled() && this.featureManager.isOnDemand()) {
            return -1;
        }
        return (Integer)this.getRole(key).map(applicationRole -> {
            int numberOfSeats = applicationRole.getNumberOfSeats();
            if (numberOfSeats == -1) {
                return -1;
            }
            int activeUsers = this.getUserCount(key);
            return Math.max(numberOfSeats - activeUsers, 0);
        }).getOrElse((Object)0);
    }

    public boolean hasSeatsAvailable(@Nonnull ApplicationKey key, int seatCount) {
        Assertions.notNull((String)"key", (Object)key);
        if (seatCount < 0) {
            throw new IllegalArgumentException("seatCount < 0");
        }
        int remainingSeats = this.getRemainingSeats(key);
        return remainingSeats == -1 || seatCount <= remainingSeats;
    }

    @Nonnull
    public Set<Group> getDefaultGroups(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        return (Set)this.getRole(key).map(ApplicationRole::getDefaultGroups).getOrElse((Object)ImmutableSet.of());
    }

    public boolean rolesEnabled() {
        return this.featureManager.isEnabled(CoreFeatures.LICENSE_ROLES_ENABLED);
    }

    private void validateRole(ApplicationRole role) {
        if (!this.licenseManager.getAllLicensedApplicationKeys().contains(role.getKey())) {
            throw new IllegalArgumentException(String.format("The '%s' role is not provided by any license.", role.getKey()));
        }
        for (Group group : role.getGroups()) {
            if (this.groupManager.groupExists(group)) continue;
            throw new IllegalArgumentException(String.format("The '%s' role is associated with group '%s', which does not exist.", role.getKey(), group.getName()));
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onFeatureChange(FeatureEvent event) {
        if (CoreFeatures.forFeatureKey((String)event.feature()) == CoreFeatures.LICENSE_ROLES_ENABLED) {
            this.clearCaches(event);
        }
    }

    @EventListener
    public void onGroupCreated(GroupCreatedEvent createdEvent) {
        this.clearCaches(createdEvent);
    }

    @EventListener
    public void onGroupDeleted(GroupDeletedEvent deletedEvent) {
        this.clearCaches(deletedEvent);
    }

    @EventListener
    public void onGroupUpdated(GroupUpdatedEvent updatedEvent) {
        this.clearCaches(updatedEvent);
    }

    @EventListener
    public void onDirectoryReorder(ApplicationDirectoryOrderUpdatedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onDirectoryUpdated(DirectoryUpdatedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onGroupMembershipCreated(GroupMembershipCreatedEvent e) {
        this.clearUserCounts(e);
    }

    @EventListener
    public void onGroupMembershipDeleted(GroupMembershipDeletedEvent e) {
        this.clearUserCounts(e);
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent e) {
        this.clearUserCounts(e);
    }

    @Override
    @Internal
    public void clearCache() {
        this.appRoleCache.removeAll();
        this.activeUsersCountForLicense.removeAll();
    }

    private void clearCaches(@Nullable Object event) {
        String eventName = event != null ? event.getClass().getName() : "<UNKNOWN>";
        log.debug("Clearing the cache on {}.", (Object)eventName);
        this.clearCache();
    }

    private void clearUserCounts(@Nullable Object event) {
        String eventName = event != null ? event.getClass().getName() : "<UNKNOWN>";
        log.debug("Clearing the user counts on {}.", (Object)eventName);
        this.activeUsersCountForLicense.removeAll();
    }

    private void clearCacheLine(ApplicationKey key) {
        log.debug("Clearing the cache line {}.", (Object)key);
        if (!ApplicationKeys.CORE.equals((Object)key)) {
            this.appRoleCache.remove((Object)ApplicationKeys.CORE);
            this.activeUsersCountForLicense.remove((Object)ApplicationKeys.CORE);
        }
        this.appRoleCache.remove((Object)key);
        this.activeUsersCountForLicense.remove((Object)key);
    }

    private static Iterable<String> groupNames(Collection<Group> groups) {
        return (Iterable)groups.stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet());
    }

    private class ActiveUserCountLoader
    implements CacheLoader<ApplicationKey, Integer> {
        private ActiveUserCountLoader() {
        }

        @Nonnull
        public Integer load(@Nonnull ApplicationKey key) {
            return (Integer)DefaultApplicationRoleManager.this.getRole(key).map(role -> {
                HashSet users = Sets.newHashSet();
                for (Group group : role.getGroups()) {
                    users.addAll(DefaultApplicationRoleManager.this.groupManager.getUsersInGroup(group).stream().filter(ApplicationUser::isActive).collect(Collectors.toList()));
                }
                if (ApplicationKeys.CORE.equals((Object)key)) {
                    DefaultApplicationRoleManager.this.getRoles().stream().filter(appRole -> !appRole.getKey().equals((Object)ApplicationKeys.CORE)).flatMap(appRole -> appRole.getGroups().stream()).map(arg_0 -> ((GroupManager)DefaultApplicationRoleManager.this.groupManager).getUsersInGroup(arg_0)).forEach(users::removeAll);
                }
                return users.size();
            }).getOrElse((Object)0);
        }
    }

    private class RoleLoader
    implements CacheLoader<ApplicationKey, Option<ApplicationRole>> {
        private RoleLoader() {
        }

        @Nonnull
        public Option<ApplicationRole> load(@Nonnull ApplicationKey key) {
            return DefaultApplicationRoleManager.this.definitions.getLicensed(key).map(appDef -> {
                ApplicationRoleStore.ApplicationRoleData applicationRoleData = DefaultApplicationRoleManager.this.applicationRoleStore.get(key);
                Set realGroups = (Set)applicationRoleData.getGroups().stream().map(arg_0 -> ((GroupManager)DefaultApplicationRoleManager.this.groupManager).getGroup(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
                Set defaultGroups = (Set)applicationRoleData.getDefaultGroups().stream().map(arg_0 -> ((GroupManager)DefaultApplicationRoleManager.this.groupManager).getGroup(arg_0)).filter(Objects::nonNull).filter(realGroups::contains).collect(CollectorsUtil.toImmutableSet());
                boolean defined = DefaultApplicationRoleManager.this.definitions.isDefined(key);
                return new DefinitionApplicationRole((ApplicationRoleDefinitions.ApplicationRoleDefinition)appDef, realGroups, defaultGroups, DefaultApplicationRoleManager.this.getNumberOfSeatsGrantedToRole(key), applicationRoleData.isSelectedByDefault(), defined);
            });
        }
    }
}

