/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationAuthorizationServiceImpl
implements ApplicationAuthorizationService {
    private final ApplicationRoleManager applicationRoleManager;
    private final GroupManager groupManager;

    public ApplicationAuthorizationServiceImpl(ApplicationRoleManager applicationRoleManager, GroupManager groupManager) {
        this.applicationRoleManager = applicationRoleManager;
        this.groupManager = groupManager;
    }

    public boolean isApplicationInstalledAndLicensed(@Nonnull ApplicationKey key) {
        return this.applicationRoleManager.isRoleInstalledAndLicensed((ApplicationKey)Assertions.notNull((String)"key", (Object)key));
    }

    public boolean isAnyRoleLimitExceeded() {
        return this.applicationRoleManager.isAnyRoleLimitExceeded();
    }

    public boolean isExceeded(@Nonnull ApplicationKey key) {
        return this.applicationRoleManager.isRoleLimitExceeded((ApplicationKey)Assertions.notNull((String)"key", (Object)key));
    }

    public boolean canUseApplication(@Nullable ApplicationUser user, @Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        if (user == null) {
            return false;
        }
        boolean canUseRole = false;
        Option applicationRole = this.applicationRoleManager.getRole(key);
        if (applicationRole.isDefined()) {
            canUseRole = this.isUserInAnyOfApplicationsGroups(user, (ApplicationRole)applicationRole.get());
        }
        if (!canUseRole && key.equals((Object)ApplicationKeys.CORE)) {
            for (ApplicationRole appRole : this.applicationRoleManager.getRoles()) {
                if (!this.isUserInAnyOfApplicationsGroups(user, appRole)) continue;
                return true;
            }
        }
        return canUseRole;
    }

    private boolean isUserInAnyOfApplicationsGroups(ApplicationUser user, ApplicationRole applicationRole) {
        for (Group appGroup : applicationRole.getGroups()) {
            if (!this.groupManager.isUserInGroup(user, appGroup)) continue;
            return true;
        }
        return false;
    }

    public int getUserCount(@Nonnull ApplicationKey key) {
        return this.applicationRoleManager.getUserCount((ApplicationKey)Assertions.notNull((String)"key", (Object)key));
    }

    public boolean rolesEnabled() {
        return this.applicationRoleManager.rolesEnabled();
    }
}

