/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.validator;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowFunctionUtils;
import com.atlassian.jira.workflow.validator.AbstractPermissionValidator;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Map;

public class PermissionValidator
extends AbstractPermissionValidator
implements Validator {
    public static ValidatorDescriptor makeDescriptor(String permission) {
        ValidatorDescriptor permValidator = DescriptorFactory.getFactory().createValidatorDescriptor();
        permValidator.setType("class");
        permValidator.getArgs().put("class.name", PermissionValidator.class.getName());
        permValidator.getArgs().put("permission", permission);
        return permValidator;
    }

    public void validate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException {
        ApplicationUser user = this.getCaller(transientVars, args);
        this.hasUserPermission(args, transientVars, user);
    }

    @VisibleForTesting
    ApplicationUser getCaller(Map transientVars, Map args) throws InvalidInputException {
        String userKey = this.getCallerKey(transientVars, args);
        ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userKey);
        if (userKey != null && user == null) {
            throw new InvalidInputException("You don't have the correct permissions - user (" + userKey + ") not found");
        }
        return user;
    }

    @VisibleForTesting
    protected String getCallerKey(Map transientVars, Map args) {
        return WorkflowFunctionUtils.getCallerKey((Map)transientVars, (Map)args);
    }
}

