/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Validator;
import java.util.Map;

public abstract class AbstractPermissionValidator
implements Validator {
    @VisibleForTesting
    void hasUserPermission(Map args, Map transientVars, ApplicationUser user) throws InvalidInputException {
        String permissionName = (String)args.get("permission");
        Issue issue = (Issue)transientVars.get("issue");
        if (!this.hasUserPermissionForIssue(issue, permissionName, user)) {
            throw new InvalidInputException("User '" + user.getUsername() + "' doesn't have the '" + permissionName + "' permission");
        }
    }

    @VisibleForTesting
    boolean hasUserPermissionForIssue(Issue issue, String permissionName, ApplicationUser user) throws InvalidInputException {
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        int permissionType = Permissions.getType((String)permissionName);
        if (issue.getGenericValue() != null) {
            return permissionManager.hasPermission(permissionType, issue, user);
        }
        if (issue.getProjectObject() != null) {
            return permissionManager.hasPermission(permissionType, issue.getProjectObject(), user);
        }
        throw new InvalidInputException("Invalid project specified.");
    }

    protected void hasUserPermission(Map args, Map transientVars, User user) throws InvalidInputException {
        this.hasUserPermission(args, transientVars, ApplicationUsers.from((User)user));
    }
}

