/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.misc;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreateCommentFunction
implements FunctionProvider {
    private static final Logger log = Logger.getLogger(CreateCommentFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) {
        try {
            String commentBody = (String)transientVars.get("comment");
            String groupLevel = (String)transientVars.get("commentLevel");
            String roleLevel = (String)transientVars.get("roleLevel");
            ImmutableMap<String, JSONObject> commentProperties = CommentSystemField.getCommentPropertiesFromParameters(transientVars);
            Long roleLevelId = null;
            if (TextUtils.stringSet((String)roleLevel)) {
                roleLevelId = Long.valueOf(roleLevel);
            }
            Issue issue = (Issue)transientVars.get("issue");
            if (TextUtils.stringSet((String)commentBody)) {
                CommentService.CommentParameters commentParameters;
                ApplicationUser author = WorkflowUtil.getCallerUser((Map)transientVars);
                CommentService commentService = (CommentService)ComponentAccessor.getComponent(CommentService.class);
                CommentService.CommentCreateValidationResult commentCreateValidationResult = commentService.validateCommentCreate(author, commentParameters = CommentService.CommentParameters.builder().author(author).body(commentBody).groupLevel(groupLevel).roleLevelId(roleLevelId).issue(issue).commentProperties(commentProperties).build());
                if (commentCreateValidationResult.isValid()) {
                    transientVars.put("commentValue", commentService.create(author, commentCreateValidationResult, false));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e), (Throwable)e);
        }
    }

    public static FunctionDescriptor makeDescriptor() {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", CreateCommentFunction.class.getName());
        return descriptor;
    }
}

