/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.concurrent.Callable;

public class WorkflowSchemeLock {
    private Multiset<Long> updatingSchemeIds = HashMultiset.create();

    public synchronized <T> T waitForUpdatesToFinishAndExecute(long schemeId, Callable<T> task) throws Exception {
        while (this.updatingSchemeIds.contains((Object)schemeId)) {
            this.wait();
        }
        return task.call();
    }

    public synchronized void startUpdate(long schemeId) {
        this.updatingSchemeIds.add((Object)schemeId);
    }

    public synchronized void stopUpdate(long schemeId) {
        this.updatingSchemeIds.remove((Object)schemeId);
        this.notifyAll();
    }
}

