/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.DraftWorkflowStore;
import com.atlassian.jira.workflow.JiraDraftWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizDraftWorkflowStore
implements DraftWorkflowStore {
    public static final String DRAFT_WORKFLOW_ENTITY_NAME = "DraftWorkflow";
    public static final String PARENTNAME_ENTITY_FIELD = "parentname";
    public static final String DESCRIPTOR_ENTITY_FIELD = "descriptor";
    private final OfBizDelegator ofBizDelegator;
    private WorkflowManager workflowManager;

    public OfBizDraftWorkflowStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public JiraWorkflow getDraftWorkflow(String parentWorkflowName) throws DataAccessException {
        WorkflowDescriptor workflowDescriptor;
        GenericValue draftWorkflowGV = this.getDraftWorkflowGV(parentWorkflowName);
        if (draftWorkflowGV == null) {
            return null;
        }
        try {
            workflowDescriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)draftWorkflowGV.getString(DESCRIPTOR_ENTITY_FIELD));
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
        return new JiraDraftWorkflow(parentWorkflowName, this.getWorkflowManager(), workflowDescriptor);
    }

    @Override
    public JiraWorkflow createDraftWorkflow(ApplicationUser author, JiraWorkflow parentWorkflow) throws DataAccessException, IllegalStateException, IllegalArgumentException {
        if (author == null) {
            throw new IllegalArgumentException("You can not create a draft workflow with a null user.");
        }
        if (parentWorkflow == null || StringUtils.isEmpty((String)parentWorkflow.getName())) {
            throw new IllegalArgumentException("Can not create a draft workflow for a parent workflow name of null.");
        }
        if (parentWorkflow.getDescriptor() == null) {
            throw new IllegalArgumentException("Can not create a draft workflow for a parent workflow with a null descriptor.");
        }
        try {
            if (this.draftWorkflowExistsForParent(parentWorkflow.getName())) {
                throw new IllegalStateException("Draft workflows table already contains a draft workflow for parent workflow with name '" + parentWorkflow.getName() + "'.");
            }
            WorkflowDescriptor parentWorkflowDescriptorCopy = this.copyAndUpdateWorkflowDescriptorMetaAttributes(parentWorkflow.getDescriptor(), author);
            Map params = EasyMap.build((Object)PARENTNAME_ENTITY_FIELD, (Object)parentWorkflow.getName(), (Object)DESCRIPTOR_ENTITY_FIELD, (Object)this.convertDescriptorToXML(parentWorkflowDescriptorCopy));
            GenericValue draftWorkflowGV = this.ofBizDelegator.createValue(DRAFT_WORKFLOW_ENTITY_NAME, params);
            WorkflowDescriptor workflowDescriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)draftWorkflowGV.getString(DESCRIPTOR_ENTITY_FIELD));
            return new JiraDraftWorkflow(parentWorkflow.getName(), this.getWorkflowManager(), workflowDescriptor);
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to create a draft workflow as the workflow is malformed.", e);
        }
    }

    @Override
    public boolean deleteDraftWorkflow(String parentWorkflowName) throws DataAccessException {
        if (StringUtils.isEmpty((String)parentWorkflowName)) {
            throw new IllegalArgumentException("Can not delete a draft workflow for a parent workflow name of null.");
        }
        return this.ofBizDelegator.removeByAnd(DRAFT_WORKFLOW_ENTITY_NAME, EasyMap.build((Object)PARENTNAME_ENTITY_FIELD, (Object)parentWorkflowName)) > 0;
    }

    @Override
    public JiraWorkflow updateDraftWorkflowWithoutAudit(String parentWorkflowName, JiraWorkflow workflow) throws DataAccessException {
        if (workflow == null || workflow.getDescriptor() == null) {
            throw new IllegalArgumentException("Can not update a draft workflow with a null workflow/descriptor.");
        }
        if (!workflow.isDraftWorkflow()) {
            throw new IllegalArgumentException("Only draft workflows may be updated via this method.");
        }
        GenericValue draftWorkflowGV = this.getDraftWorkflowGV(parentWorkflowName);
        if (draftWorkflowGV == null) {
            throw new IllegalArgumentException("Unable to find a draft workflow associated with the parent workflow name '" + parentWorkflowName + "'");
        }
        try {
            Object existingDraftUpdateDate;
            String parentWorkflowXML = this.convertDescriptorToXML(workflow.getDescriptor());
            WorkflowDescriptor updatedDescriptor = this.convertXMLtoWorkflowDescriptor(parentWorkflowXML);
            WorkflowDescriptor existingDescriptor = this.convertXMLtoWorkflowDescriptor(draftWorkflowGV.getString(DESCRIPTOR_ENTITY_FIELD));
            Object existingDraftAuthor = existingDescriptor.getMetaAttributes().get("jira.update.author.key");
            if (existingDraftAuthor != null) {
                updatedDescriptor.getMetaAttributes().put("jira.update.author.key", existingDraftAuthor);
            }
            if ((existingDraftUpdateDate = existingDescriptor.getMetaAttributes().get("jira.updated.date")) != null) {
                updatedDescriptor.getMetaAttributes().put("jira.updated.date", existingDraftUpdateDate);
            }
            draftWorkflowGV.setString(DESCRIPTOR_ENTITY_FIELD, this.convertDescriptorToXML(updatedDescriptor));
            try {
                draftWorkflowGV.store();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Unable to update the draft workflow associated with parentWorkflowName '" + parentWorkflowName + "'", (Throwable)e);
            }
            return new JiraDraftWorkflow(parentWorkflowName, this.getWorkflowManager(), this.convertXMLtoWorkflowDescriptor(draftWorkflowGV.getString(DESCRIPTOR_ENTITY_FIELD)));
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to update a draft workflow as the workflow to save is malformed.", e);
        }
    }

    @Override
    public JiraWorkflow updateDraftWorkflow(ApplicationUser user, String parentWorkflowName, JiraWorkflow workflow) throws DataAccessException {
        if (user == null) {
            throw new IllegalArgumentException("Can not update a draft workflow with a null user.");
        }
        if (workflow == null || workflow.getDescriptor() == null) {
            throw new IllegalArgumentException("Can not update a draft workflow with a null workflow/descriptor.");
        }
        if (!workflow.isDraftWorkflow()) {
            throw new IllegalArgumentException("Only draft workflows may be updated via this method.");
        }
        GenericValue draftWorkflowGV = this.getDraftWorkflowGV(parentWorkflowName);
        if (draftWorkflowGV == null) {
            throw new IllegalArgumentException("Unable to find a draft workflow associated with the parent workflow name '" + parentWorkflowName + "'");
        }
        try {
            WorkflowDescriptor updatedDescriptor = this.copyAndUpdateWorkflowDescriptorMetaAttributes(workflow.getDescriptor(), user);
            draftWorkflowGV.setString(DESCRIPTOR_ENTITY_FIELD, this.convertDescriptorToXML(updatedDescriptor));
            try {
                draftWorkflowGV.store();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Unable to update the draft workflow associated with parentWorkflowName '" + parentWorkflowName + "'", (Throwable)e);
            }
            return new JiraDraftWorkflow(parentWorkflowName, this.getWorkflowManager(), this.convertXMLtoWorkflowDescriptor(draftWorkflowGV.getString(DESCRIPTOR_ENTITY_FIELD)));
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to update a draft workflow as the workflow to save is malformed.", e);
        }
    }

    boolean draftWorkflowExistsForParent(String parentWorkflowName) {
        List temporaryGVs = this.ofBizDelegator.findByAnd(DRAFT_WORKFLOW_ENTITY_NAME, EasyMap.build((Object)PARENTNAME_ENTITY_FIELD, (Object)parentWorkflowName));
        return temporaryGVs.size() > 0;
    }

    private WorkflowDescriptor copyAndUpdateWorkflowDescriptorMetaAttributes(WorkflowDescriptor parentWorkflow, ApplicationUser author) throws FactoryException {
        String parentWorkflowXML = this.convertDescriptorToXML(parentWorkflow);
        WorkflowDescriptor workflowDescriptor = this.convertXMLtoWorkflowDescriptor(parentWorkflowXML);
        workflowDescriptor.getMetaAttributes().put("jira.update.author.key", author.getKey());
        workflowDescriptor.getMetaAttributes().put("jira.updated.date", Long.toString(System.currentTimeMillis()));
        return workflowDescriptor;
    }

    WorkflowManager getWorkflowManager() {
        if (this.workflowManager == null) {
            this.workflowManager = ComponentAccessor.getWorkflowManager();
        }
        return this.workflowManager;
    }

    WorkflowDescriptor convertXMLtoWorkflowDescriptor(String parentWorkflowXML) throws FactoryException {
        return WorkflowUtil.convertXMLtoWorkflowDescriptor((String)parentWorkflowXML);
    }

    String convertDescriptorToXML(WorkflowDescriptor descriptor) {
        return WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)descriptor);
    }

    GenericValue getDraftWorkflowGV(String parentWorkflowName) {
        if (StringUtils.isEmpty((String)parentWorkflowName)) {
            throw new IllegalArgumentException("Can not get a draft workflow for a parent workflow name of null.");
        }
        List draftWorkflowGVs = this.ofBizDelegator.findByAnd(DRAFT_WORKFLOW_ENTITY_NAME, EasyMap.build((Object)PARENTNAME_ENTITY_FIELD, (Object)parentWorkflowName));
        if (draftWorkflowGVs.size() == 0) {
            return null;
        }
        if (draftWorkflowGVs.size() > 1) {
            throw new IllegalStateException("There are more than one draft workflows associated with the workflow named '" + parentWorkflowName + "'");
        }
        return (GenericValue)draftWorkflowGVs.get(0);
    }
}

