/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.jira.workflow.DraftWorkflowStore;
import com.atlassian.jira.workflow.JiraDraftWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.util.concurrent.NotNull;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

@EventComponent
public class CachingDraftWorkflowStore
implements DraftWorkflowStore {
    private final DraftWorkflowStore delegate;
    private WorkflowManager workflowManager;
    private final Cache<String, CacheObject<String>> draftWorkflowCache;

    public CachingDraftWorkflowStore(DraftWorkflowStore delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.draftWorkflowCache = cacheManager.getCache(CachingDraftWorkflowStore.class.getName() + ".draftWorkflowCache", (CacheLoader)new DraftWorkflowCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.draftWorkflowCache.removeAll();
    }

    @Override
    public JiraWorkflow getDraftWorkflow(String parentWorkflowName) throws DataAccessException {
        if (StringUtils.isEmpty((String)parentWorkflowName)) {
            throw new IllegalArgumentException("Can not get a draft workflow for a parent workflow name of null.");
        }
        CacheObject cacheObject = (CacheObject)this.draftWorkflowCache.get((Object)parentWorkflowName);
        if (cacheObject.equals(CacheObject.NULL_INSTANCE)) {
            return null;
        }
        return this.getJiraDraftWorkflow(parentWorkflowName, (String)cacheObject.getValue());
    }

    @Override
    public JiraWorkflow createDraftWorkflow(ApplicationUser author, JiraWorkflow parentWorkflow) throws DataAccessException, IllegalStateException, IllegalArgumentException {
        JiraWorkflow draftWorkflow = this.delegate.createDraftWorkflow(author, parentWorkflow);
        this.draftWorkflowCache.remove((Object)parentWorkflow.getName());
        return draftWorkflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDraftWorkflow(String parentWorkflowName) throws DataAccessException, IllegalArgumentException {
        boolean deleted;
        try {
            deleted = this.delegate.deleteDraftWorkflow(parentWorkflowName);
        }
        finally {
            this.draftWorkflowCache.remove((Object)parentWorkflowName);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JiraWorkflow updateDraftWorkflow(ApplicationUser user, String parentWorkflowName, JiraWorkflow workflow) throws DataAccessException {
        try {
            JiraWorkflow updatedWorkflow;
            JiraWorkflow jiraWorkflow = updatedWorkflow = this.delegate.updateDraftWorkflow(user, parentWorkflowName, workflow);
            return jiraWorkflow;
        }
        finally {
            this.draftWorkflowCache.remove((Object)parentWorkflowName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JiraWorkflow updateDraftWorkflowWithoutAudit(String parentWorkflowName, JiraWorkflow workflow) throws DataAccessException {
        try {
            JiraWorkflow updatedWorkflow;
            JiraWorkflow jiraWorkflow = updatedWorkflow = this.delegate.updateDraftWorkflowWithoutAudit(parentWorkflowName, workflow);
            return jiraWorkflow;
        }
        finally {
            this.draftWorkflowCache.remove((Object)parentWorkflowName);
        }
    }

    WorkflowManager getWorkflowManager() {
        if (this.workflowManager == null) {
            this.workflowManager = ComponentAccessor.getWorkflowManager();
        }
        return this.workflowManager;
    }

    WorkflowDescriptor convertXMLtoWorkflowDescriptor(String parentWorkflowXML) throws FactoryException {
        return WorkflowUtil.convertXMLtoWorkflowDescriptor((String)parentWorkflowXML);
    }

    String convertDescriptorToXML(WorkflowDescriptor descriptor) {
        return WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)descriptor);
    }

    private JiraWorkflow getJiraDraftWorkflow(String name, String workflowDescriptorXML) {
        try {
            return new JiraDraftWorkflow(name, this.getWorkflowManager(), this.convertXMLtoWorkflowDescriptor(workflowDescriptorXML));
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }

    private class DraftWorkflowCacheLoader
    implements CacheLoader<String, CacheObject<String>> {
        private DraftWorkflowCacheLoader() {
        }

        public CacheObject<String> load(@NotNull String parentWorkflowName) {
            JiraWorkflow draftWorkflow = CachingDraftWorkflowStore.this.delegate.getDraftWorkflow(parentWorkflowName);
            if (draftWorkflow == null) {
                return CacheObject.NULL();
            }
            return CacheObject.wrap(CachingDraftWorkflowStore.this.convertDescriptorToXML(draftWorkflow.getDescriptor()));
        }
    }
}

