/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webwork;

import com.atlassian.jira.action.SafeAction;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.webwork.parameters.KnownParameterConverters;
import com.atlassian.jira.webwork.parameters.ParameterConverter;
import com.google.common.collect.MapMaker;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.action.IllegalArgumentAware;

public class JiraSafeActionParameterSetter {
    private static final Logger log = Logger.getLogger(JiraSafeActionParameterSetter.class);
    @ClusterSafe
    private final ConcurrentMap<Class<? extends Action>, PropertyDescriptor[]> setterPropertyDescriptors = new MapMaker().weakKeys().makeMap();

    public void setSafeParameters(Action action, Map<String, ?> webParameters) {
        Assertions.notNull((String)"action", (Object)action);
        Assertions.not((String)"backend action passed in", (boolean)(action instanceof SafeAction));
        if (webParameters == null) {
            return;
        }
        Set<String> parameterKeys = webParameters.keySet();
        if (parameterKeys.isEmpty()) {
            return;
        }
        PropertyDescriptor[] setterDescriptors = this.getSetterPropertyDescriptors(action);
        if (setterDescriptors.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("This action does not have any settable properties : '" + action + "'"));
            }
            return;
        }
        for (String paramName : parameterKeys) {
            String[] paramValue = this.normaliseToStringArr(webParameters, paramName);
            if (paramValue == null) continue;
            Method setterMethod = this.getSetterForParameter(paramName, setterDescriptors);
            if (setterMethod != null) {
                try {
                    this.setActionProperty(setterMethod, action, paramValue);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unable invoke setter '" + setterMethod + "' with parameter '" + paramName + "'"), (Throwable)iae);
                    }
                    if (action instanceof IllegalArgumentAware) {
                        ((IllegalArgumentAware)action).addIllegalArgumentException(paramName, iae);
                        continue;
                    }
                    throw iae;
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("No property setter is availble on Action '" + action.getClass() + "' for parameter '" + paramName + "'"));
        }
    }

    private void setActionProperty(Method setterMethod, Action action, String[] paramValue) {
        Assertions.notNull((String)"paramValue", (Object)paramValue);
        Assertions.notNull((String)"setterMethod", (Object)setterMethod);
        Assertions.notNull((String)"setterMethod", setterMethod.getParameterTypes());
        Assertions.stateTrue((String)"setterMethod", (setterMethod.getParameterTypes().length == 1 ? 1 : 0) != 0);
        Class<?> parameterType = setterMethod.getParameterTypes()[0];
        try {
            Object convertedObj;
            if (parameterType.equals(String.class)) {
                convertedObj = paramValue[0];
            } else if (parameterType.equals(String[].class)) {
                convertedObj = paramValue;
            } else {
                ParameterConverter converter = KnownParameterConverters.getConverter(parameterType);
                Assertions.notNull((String)"converter", (Object)converter);
                convertedObj = converter.convertParameter(paramValue, parameterType);
            }
            setterMethod.invoke((Object)action, convertedObj);
        }
        catch (IllegalArgumentException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to convert property value for setter '" + setterMethod + "'"));
            }
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Method getSetterForParameter(final String paramName, PropertyDescriptor[] setterDescriptors) {
        PropertyDescriptor descriptor = (PropertyDescriptor)CollectionUtil.findFirstMatch(Arrays.asList(setterDescriptors), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean evaluate(PropertyDescriptor input) {
                return paramName.equals(input.getName());
            }
        });
        return descriptor == null ? null : descriptor.getWriteMethod();
    }

    private PropertyDescriptor[] getSetterPropertyDescriptors(Action action) {
        Class<?> actionClass = action.getClass();
        PropertyDescriptor[] descriptors = (PropertyDescriptor[])this.setterPropertyDescriptors.get(actionClass);
        if (descriptors == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(actionClass, Object.class);
            }
            catch (IntrospectionException e) {
                return new PropertyDescriptor[0];
            }
            descriptors = beanInfo.getPropertyDescriptors();
            ArrayList<PropertyDescriptor> descriptorList = new ArrayList<PropertyDescriptor>(descriptors.length);
            for (PropertyDescriptor descriptor : descriptors) {
                Method setterMethod = descriptor.getWriteMethod();
                if (descriptor instanceof IndexedPropertyDescriptor || !this.isMethodShapeOk(setterMethod)) continue;
                descriptorList.add(descriptor);
            }
            Collections.sort(descriptorList, new SetterDescriptorComparator());
            descriptors = new PropertyDescriptor[descriptorList.size()];
            descriptorList.toArray(descriptors);
            PropertyDescriptor[] result = this.setterPropertyDescriptors.putIfAbsent(actionClass, descriptors);
            return result == null ? descriptors : result;
        }
        return descriptors;
    }

    private boolean isMethodShapeOk(Method setterMethod) {
        Class<?>[] parameterTypes;
        int modifiers;
        boolean ok = false;
        if (setterMethod != null && Modifier.isPublic(modifiers = setterMethod.getModifiers()) && (!Modifier.isAbstract(modifiers) || Modifier.isStatic(modifiers)) && (parameterTypes = setterMethod.getParameterTypes()) != null && parameterTypes.length == 1 && !setterMethod.getDeclaringClass().equals(Object.class)) {
            Class<?> parameterType = parameterTypes[0];
            ParameterConverter converter = KnownParameterConverters.getConverter(parameterType);
            if (converter != null) {
                ok = true;
            } else if (String.class.equals(parameterType) || String[].class.equals(parameterType)) {
                ok = true;
            }
        }
        return ok;
    }

    private String[] normaliseToStringArr(Map<String, ?> parameterMap, String paramName) {
        String[] returnValue;
        String[] stringArray;
        Object paramValue = parameterMap.get(paramName);
        if (paramValue == null) {
            return null;
        }
        if (paramValue instanceof String[]) {
            stringArray = (String[])paramValue;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(paramValue);
        }
        for (String aReturnValue : returnValue = stringArray) {
            if (aReturnValue == null) continue;
            return returnValue;
        }
        return null;
    }

    static class SetterDescriptorComparator
    implements Comparator<PropertyDescriptor> {
        SetterDescriptorComparator() {
        }

        @Override
        public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
            Class<?> parameterType1 = o1.getWriteMethod().getParameterTypes()[0];
            Class<?> parameterType2 = o2.getWriteMethod().getParameterTypes()[0];
            return this.preferArrays(parameterType1, parameterType2);
        }

        private int preferArrays(Class<?> parameterType1, Class<?> parameterType2) {
            if (parameterType1.isArray() && parameterType2.isArray()) {
                return 0;
            }
            if (!parameterType1.isArray() && !parameterType2.isArray()) {
                return 0;
            }
            return parameterType1.isArray() ? 1 : -1;
        }
    }
}

