/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.util.ExceptionInterpreterUtil;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalServerErrorExceptionDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(InternalServerErrorExceptionDataSource.class);
    private final Throwable exception;
    private final ExtendedSystemInfoUtils extendedSystemInfoUtils;
    private String stacktrace = null;
    private String rootCause = null;

    public InternalServerErrorExceptionDataSource(Throwable exception, @Nullable ExtendedSystemInfoUtils extendedSystemInfoUtils) {
        this.exception = exception;
        this.extendedSystemInfoUtils = extendedSystemInfoUtils;
        this.parseException();
    }

    protected void parseException() {
        if (this.exception != null) {
            Throwable rootCause;
            Throwable cause = this.exception;
            if (this.exception instanceof ServletException && (rootCause = ((ServletException)this.exception).getRootCause()) != null) {
                cause = rootCause;
            }
            this.rootCause = cause.toString();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            cause.printStackTrace(pw);
            this.stacktrace = sw.toString();
        }
    }

    public String getInterpretedMessage() {
        if (this.extendedSystemInfoUtils != null) {
            String execute = ExceptionInterpreterUtil.execute(this.extendedSystemInfoUtils, this.getStacktrace());
            return StringUtils.defaultString((String)execute);
        }
        return "";
    }

    public String getStacktrace() {
        return StringUtils.defaultString((String)this.stacktrace);
    }

    public String getRootCause() {
        return StringUtils.defaultString((String)this.rootCause);
    }
}

