/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.rpc;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.plugin.rpc.SoapModuleDescriptor;
import com.atlassian.jira.soap.axis.JiraAxisServerFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.servlet.rpc.AxisServletProvider;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import javax.servlet.ServletConfig;
import org.apache.axis.AxisProperties;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.transport.http.AxisServlet;

public class PluggableAxisServletProvider
implements AxisServletProvider {
    private final EventPublisher eventPublisher;
    @ClusterSafe(value="Driven by plugin state, which is kept in synch across the cluster")
    private volatile Holder holder;

    public PluggableAxisServletProvider(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void init(ServletConfig config) {
        if (!this.isInitialized()) {
            this.holder = new Holder(config);
            this.eventPublisher.register((Object)this.holder);
        }
    }

    @Override
    public void reset() {
        if (this.isInitialized()) {
            this.holder.reset();
        }
    }

    @Override
    public AxisServlet getAxisServlet() {
        Assertions.stateTrue((String)"Not initialized", (boolean)this.isInitialized());
        return (AxisServlet)this.holder.get();
    }

    private boolean isInitialized() {
        return this.holder != null;
    }

    public static final class Holder
    extends ResettableLazyReference<AxisServlet> {
        private final ServletConfig config;

        private Holder(ServletConfig config) {
            this.config = config;
        }

        protected AxisServlet create() throws Exception {
            AxisProperties.setProperty((String)"axis.ServerFactory", (String)JiraAxisServerFactory.class.getName());
            AxisProperties.setProperty((String)"axis.doAutoTypes", (String)Boolean.TRUE.toString());
            TypeMappingImpl.dotnet_soapenc_bugfix = true;
            AxisServlet axisServlet = new AxisServlet();
            axisServlet.init(this.config);
            return axisServlet;
        }

        public void reset() {
            AxisServlet current = null;
            if (this.isInitialized()) {
                current = (AxisServlet)this.get();
            }
            super.reset();
            if (current != null) {
                current.destroy();
            }
        }

        @EventListener
        public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
            this.onPluginModuleEvent(event.getModule());
        }

        @EventListener
        public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
            this.onPluginModuleEvent(event.getModule());
        }

        private void onPluginModuleEvent(ModuleDescriptor<?> moduleDescriptor) {
            if (moduleDescriptor instanceof SoapModuleDescriptor) {
                this.reset();
            }
        }
    }
}

