/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.InternalServerErrorDataSource;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.atlassian.jira.web.util.PrettyObjectPrinter;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalServerErrorServlet
extends HttpServlet {
    private static final Logger generalLog = LoggerFactory.getLogger(InternalServerErrorServlet.class);

    private void doRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            boolean shouldShowFullInfo;
            String id = UUID.randomUUID().toString();
            Logger log = LoggerFactory.getLogger((String)("500ErrorPage." + id));
            resp.setContentType("text/html");
            ImmutableMap.Builder map = ImmutableMap.builder();
            map.put((Object)"footer", (Object)this.getFooterContent(req));
            map.put((Object)"helpsteps", this.prepareHelpSteps(req));
            map.put((Object)"resourcesContent", (Object)MetalResourcesManager.getMetalResources(req.getContextPath()));
            if (!this.isOnDemand() || this.isLoggedInAdmin()) {
                map.put((Object)"errorId", (Object)id);
            }
            InternalServerErrorDataSource ds = this.initializeInternalServerErrorDS(req, log);
            ImmutableMap.Builder technicalDetails = ImmutableMap.builder();
            boolean bl = shouldShowFullInfo = this.isLoggedInAdmin() || JiraSystemProperties.isDevMode();
            if (shouldShowFullInfo && !"true".equals(req.getParameter("short"))) {
                ds.appendFullMessageData((ImmutableMap.Builder<String, Object>)technicalDetails, this.isLoggedInSysAdmin() || JiraSystemProperties.isDevMode());
                map.put((Object)"fullInfo", (Object)true);
            } else {
                ds.appendSimpleMessageData((ImmutableMap.Builder<String, Object>)technicalDetails);
                map.put((Object)"fullInfo", (Object)false);
                ds.notForSoy();
                ImmutableMap.Builder rawMapBuilder = ImmutableMap.builder();
                ImmutableMap soyData = ds.appendFullMessageData((ImmutableMap.Builder<String, Object>)rawMapBuilder, true).build();
                PrettyObjectPrinter pop = new PrettyObjectPrinter(soyData);
                log.debug(pop.toString());
            }
            map.put((Object)"technicalDetails", (Object)technicalDetails.build());
            ImmutableMap build = map.build();
            SoyTemplateRenderer renderer = (SoyTemplateRenderer)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
            renderer.render((Appendable)resp.getWriter(), "jira.webresources:jira-errors", "JIRA.Templates.errors.InternalError.page", (Map)build);
        }
        catch (SoyException e) {
            generalLog.error("Cannot render soy template", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp);
    }

    private boolean isOnDemand() {
        FeatureManager featureManager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
        if (featureManager == null) {
            return true;
        }
        return featureManager.isOnDemand();
    }

    private String getContactAdministratorLink(HttpServletRequest req) {
        JiraContactHelper jiraContactHelper = (JiraContactHelper)ComponentAccessor.getComponent(JiraContactHelper.class);
        if (jiraContactHelper == null) {
            return null;
        }
        if (!jiraContactHelper.isAdministratorContactFormEnabled()) {
            return null;
        }
        return jiraContactHelper.getAdministratorContactLink(req.getContextPath());
    }

    private InternalServerErrorDataSource initializeInternalServerErrorDS(HttpServletRequest req, Logger log) {
        I18nHelper i18nBean = this.getI18nHelper();
        ExtendedSystemInfoUtilsImpl extendedSystemInfoUtils = null;
        try {
            extendedSystemInfoUtils = new ExtendedSystemInfoUtilsImpl(i18nBean);
        }
        catch (Exception e) {
            log.warn("Cannot initialize ExtendedSystemInfoUtilsImpl", (Throwable)e);
        }
        return new InternalServerErrorDataSource(i18nBean, extendedSystemInfoUtils, this.getServletContext(), ComponentAccessor.getLocaleManager(), req);
    }

    private I18nHelper getI18nHelper() {
        return ((JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).getI18nHelper();
    }

    private boolean isLoggedInAdmin() {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (user == null) {
            return false;
        }
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        return permissionManager.hasPermission(0, user) || permissionManager.hasPermission(44, user);
    }

    private boolean isLoggedInSysAdmin() {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (user == null) {
            return false;
        }
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        return permissionManager.hasPermission(44, user);
    }

    private String getFooterContent(HttpServletRequest httpRequest) {
        PluginAccessor pluginAccessor = ComponentAccessor.getPluginAccessor();
        if (pluginAccessor == null) {
            return "";
        }
        FooterModuleDescriptor footer = (FooterModuleDescriptor)pluginAccessor.getEnabledPluginModule("jira.footer:standard-footer");
        if (footer == null) {
            return "";
        }
        return ((PluggableFooter)footer.getModule()).getFullFooterHtml(httpRequest);
    }

    private List<String> prepareHelpSteps(HttpServletRequest req) {
        I18nHelper i18n = this.getI18nHelper();
        if (this.isOnDemand()) {
            if (this.isLoggedInAdmin()) {
                ExternalLinkUtilImpl externalLinkUtil = new ExternalLinkUtilImpl();
                String sac = externalLinkUtil.getProperty("external.link.jira.support.site");
                return ImmutableList.of((Object)i18n.getText("500.raise.an.issue.on.sac", "<a href=\"" + sac + "\">", "</a>"));
            }
            String contactAdministratorsLink = this.getContactAdministratorLink(req);
            return ImmutableList.of((Object)(contactAdministratorsLink != null ? i18n.getText("500.send.to.your.jira.admin.contact.form", "<a target=\"_blank\" href=\"" + contactAdministratorsLink + "\">", "</a>") : i18n.getText("500.send.to.your.jira.admin")));
        }
        if (this.isLoggedInAdmin()) {
            ExternalLinkUtilImpl externalLinkUtil = new ExternalLinkUtilImpl();
            String sac = externalLinkUtil.getProperty("external.link.jira.support.site");
            String stp = req.getContextPath() + "/plugins/servlet/stp/view/#support-zip";
            return ImmutableList.of((Object)i18n.getText("500.collect.when.problem.occurred"), (Object)i18n.getText("500.collect.server.log"), (Object)i18n.getText("500.create.support.zip", "<a target=\"_blank\" href=\"" + stp + "\">", "</a>"), (Object)i18n.getText("500.raise.an.issue.with.all.info", "<a href=\"" + sac + "\">", "</a>"));
        }
        String contactAdministratorsLink = this.getContactAdministratorLink(req);
        return ImmutableList.of((Object)(contactAdministratorsLink != null ? i18n.getText("500.send.with.ref.to.your.jira.admin.contact.form", "<a target=\"_blank\" href=\"" + contactAdministratorsLink + "\">", "</a>") : i18n.getText("500.send.with.ref.to.your.jira.admin")));
    }
}

