/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.web.HttpRequestLocal;
import com.atlassian.jira.web.pagebuilder.DecoratorListener;
import com.atlassian.jira.web.pagebuilder.DefaultPageBuilder;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.jira.web.pagebuilder.PageBuilder;
import com.atlassian.jira.web.pagebuilder.PageBuilderServiceSpi;
import com.atlassian.jira.web.pagebuilder.PageBuilderSpi;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.assembler.DefaultPageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultJiraPageBuilderService
extends DefaultPageBuilderService
implements JiraPageBuilderService,
PageBuilderServiceSpi {
    private final ApplicationProperties applicationProperties;
    private final HttpRequestLocal<DefaultPageBuilder> pageBuilderRequestLocal = new HttpRequestLocal("page.builder");

    public DefaultJiraPageBuilderService(ApplicationProperties applicationProperties, WebResourceIntegration webResourceIntegration, WebResourceAssemblerFactory webResourceAssemblerFactory) {
        super(webResourceIntegration, webResourceAssemblerFactory);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void initForRequest(HttpServletRequest request, HttpServletResponse response, DecoratorListener decoratorListener, ServletContext servletContext) {
        if (null == this.pageBuilderRequestLocal.get()) {
            this.pageBuilderRequestLocal.set(new DefaultPageBuilder(this.applicationProperties, request, response, decoratorListener, servletContext));
        }
    }

    @Override
    public void clearForRequest() {
        this.pageBuilderRequestLocal.remove();
    }

    @Override
    public PageBuilder get() {
        PageBuilder pageBuilder = this.pageBuilderRequestLocal.get();
        if (null == pageBuilder) {
            throw new IllegalStateException("PageBuilderService.get() called before page builder has been initialised for this request");
        }
        return pageBuilder;
    }

    @Override
    public PageBuilderSpi getSpi() {
        PageBuilderSpi pageBuilderSpi = this.pageBuilderRequestLocal.get();
        if (null == pageBuilderSpi) {
            throw new IllegalStateException("PageBuilderServiceSpi.getSpi() called before page builder has been initialised for this request");
        }
        return pageBuilderSpi;
    }
}

