/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.less;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.web.less.inlineimage.InlineImageEncoder;
import com.atlassian.jira.web.util.CssSubstitutionWebResourceTransformer;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Environment;

public class LessTransformer
implements WebResourceTransformer {
    private static final Logger log = Logger.getLogger(LessTransformer.class);
    private static final Pattern CSS_LITERAL = Pattern.compile("^(([A-Za-z-]+)|(#[A-Za-z0-9]+)|(\\d*\\.?\\d+? *(px|%|em|pc|ex|in|deg|s|ms|pt|cm|mm|rad|grad|turn)?)|[\"'])$");
    private static final String ATLASSIAN_WEBRESOURCE_DISABLE_MINIFICATION = "atlassian.webresource.disable.minification";
    @ClusterSafe(value="Used simply for lazy initialisation")
    private static final Supplier<LessCompiler> LESSC = new LazyReference<LessCompiler>(){

        protected LessCompiler create() throws Exception {
            return new LessCompiler();
        }
    };
    private static final DevModeCache devModeCache = new DevModeCache();
    private final ApplicationProperties applicationProperties;
    private final ServletContextFactory servletContextFactory;
    private final PluginAccessor pluginAccessor;
    private final WebResourceIntegration webResourceIntegration;
    private final JiraProperties jiraSystemProperties;

    public LessTransformer(ApplicationProperties applicationProperties, ServletContextFactory servletContextFactory, PluginAccessor pluginAccessor, WebResourceIntegration webResourceIntegration, JiraProperties jiraSystemProperties) throws IOException {
        this.applicationProperties = applicationProperties;
        this.servletContextFactory = servletContextFactory;
        this.pluginAccessor = pluginAccessor;
        this.webResourceIntegration = webResourceIntegration;
        this.jiraSystemProperties = jiraSystemProperties;
    }

    public DownloadableResource transform(Element element, ResourceLocation resourceLocation, String extrapath, DownloadableResource downloadableResource) {
        boolean minificationDisabled;
        boolean devMode = this.isDevMode();
        boolean bl = minificationDisabled = this.jiraSystemProperties.getBoolean(ATLASSIAN_WEBRESOURCE_DISABLE_MINIFICATION) != false || devMode;
        if (this.isDevMode()) {
            return new CachingDevModeLessResource(devModeCache, LessTransformer.pluginKeyForElement(element), resourceLocation, downloadableResource, minificationDisabled);
        }
        if (minificationDisabled) {
            return new DevModeLessResource(LessTransformer.pluginKeyForElement(element), resourceLocation, downloadableResource, minificationDisabled);
        }
        return new LessResource(LessTransformer.pluginKeyForElement(element), resourceLocation, downloadableResource, minificationDisabled);
    }

    private static String pluginKeyForElement(Element element) {
        String pluginKey = null;
        Element p = element;
        while ((p = p.getParent()) != null) {
            if (!p.getName().equals("atlassian-plugin")) continue;
            pluginKey = p.attributeValue("key");
        }
        return pluginKey;
    }

    private boolean isDevMode() {
        return this.jiraSystemProperties.getBoolean("atlassian.dev.mode");
    }

    private String makeLookAndFeelLess() {
        LookAndFeelBean laf = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        CssSubstitutionWebResourceTransformer.VariableMap variableMap = new CssSubstitutionWebResourceTransformer.VariableMap(laf, this.webResourceIntegration);
        StringBuilder out = new StringBuilder();
        for (Map.Entry<String, String> entry : variableMap.getVariableMap(false).entrySet()) {
            out.append("@").append(entry.getKey()).append(": ");
            out.append(this.encodeValue(entry.getValue())).append(";\n");
        }
        return out.toString();
    }

    private String encodeValue(String value) {
        if (CSS_LITERAL.matcher(value = StringUtils.trimToEmpty((String)value)).matches()) {
            return value;
        }
        value = value.replaceAll("['\"]", "\\$0");
        return '\"' + value + '\"';
    }

    private String stripLeadingSlash(String location) {
        if (location == null) {
            return "";
        }
        return location.startsWith("/") ? location.substring(1) : location;
    }

    static class DevModeCache {
        @ClusterSafe
        private final Map<String, Node> map = new ConcurrentHashMap<String, Node>(0);

        DevModeCache() {
        }

        public CharSequence get(String cacheKey, CharSequence originalContent) {
            Node node = this.map.get(cacheKey);
            if (node == null) {
                return null;
            }
            String orig = ((Object)originalContent).toString();
            if (node.dependencies.isUpToDate(orig)) {
                return node.result;
            }
            this.map.remove(cacheKey);
            return null;
        }

        public void put(String cacheKey, DependencyTracker dependencies, CharSequence result) {
            this.map.put(cacheKey, new Node(dependencies, ((Object)result).toString()));
        }

        static class Node {
            final DependencyTracker dependencies;
            final String result;

            Node(DependencyTracker dependencies, String result) {
                this.dependencies = dependencies;
                this.result = result;
            }
        }
    }

    public static class DependencyTracker {
        private final boolean enabled;
        private volatile String originalContent;
        private final Collection<Callable<Boolean>> checks = new ConcurrentLinkedQueue<Callable<Boolean>>();

        public DependencyTracker(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isUpToDate(String currentContent) {
            if (!this.enabled) {
                return false;
            }
            if (!currentContent.equals(this.originalContent)) {
                return false;
            }
            for (Callable<Boolean> check : this.checks) {
                try {
                    if (check.call().booleanValue()) continue;
                    return false;
                }
                catch (Exception e) {
                    log.debug((Object)"Unable to check if resource isUpToDate. Assuming it is not.", (Throwable)e);
                    return false;
                }
            }
            return true;
        }

        public void add(Callable<Boolean> check) {
            if (!this.enabled) {
                return;
            }
            this.checks.add(check);
        }

        public void addOriginalContent(CharSequence originalContent) {
            if (!this.enabled) {
                return;
            }
            this.originalContent = ((Object)originalContent).toString();
        }
    }

    public static class URLUptodateCheck
    implements Callable<Boolean> {
        private final long originalLastModified;
        private final URL url;

        public URLUptodateCheck(long originalLastModified, URL url) {
            this.originalLastModified = originalLastModified;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getLastModified(URL url) {
            long l;
            URLConnection urlConnection = url.openConnection();
            try {
                l = urlConnection.getLastModified();
            }
            catch (Throwable throwable) {
                try {
                    Closeables.closeQuietly((Closeable)urlConnection.getInputStream());
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Closeables.closeQuietly((Closeable)urlConnection.getInputStream());
            return l;
        }

        @Override
        public Boolean call() throws Exception {
            long lastModified = this.getLastModified(this.url);
            return this.originalLastModified == lastModified;
        }
    }

    static class LookAndFeelUptodateCheck
    implements Callable<Boolean> {
        private final long originalVersion = LookAndFeelBean.getInstance((ApplicationProperties)ComponentAccessor.getApplicationProperties()).getVersion();

        LookAndFeelUptodateCheck() {
        }

        @Override
        public Boolean call() throws Exception {
            return this.originalVersion == LookAndFeelBean.getInstance((ApplicationProperties)ComponentAccessor.getApplicationProperties()).getVersion();
        }
    }

    static class LessCompiler {
        private final Scriptable sharedScope;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LessCompiler() throws IOException {
            ContextFactory cf = new ContextFactory();
            Context cx = cf.enterContext();
            try {
                cx.setOptimizationLevel(9);
                ScriptableObject scope = cx.initStandardObjects();
                Environment.defineClass((ScriptableObject)scope);
                scope.defineProperty("environment", (Object)new Environment(scope), 2);
                this.loadjs((Scriptable)scope, cx, "setup-env.js");
                this.loadjs((Scriptable)scope, cx, "less-concat.js");
                Function init = (Function)scope.get("init", (Scriptable)scope);
                init.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[0]);
                scope.sealObject();
                this.sharedScope = scope;
            }
            finally {
                Context.exit();
            }
        }

        private void loadjs(Scriptable topScope, Context cx, String name) throws IOException {
            InputStream in = this.getClass().getResourceAsStream(name);
            if (in == null) {
                throw new FileNotFoundException("Could not find JS resource " + name);
            }
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            cx.evaluateReader(topScope, (Reader)reader, name, 1, null);
        }

        public String compile(String location, LessResource.BaseLoader loader, String input, boolean compress) {
            ContextFactory cf = new ContextFactory();
            Context cx = cf.enterContext();
            try {
                Function runLessRun = (Function)this.sharedScope.get("runLessRun", this.sharedScope);
                Scriptable newScope = cx.newObject(this.sharedScope);
                newScope.setPrototype(this.sharedScope);
                newScope.setParentScope(null);
                try {
                    Object[] args = new Object[]{location, loader, input, compress};
                    Object result = runLessRun.call(cx, newScope, newScope, args);
                    String string = Context.toString((Object)result);
                    return string;
                }
                catch (JavaScriptException e) {
                    throw new RuntimeException(this.debugJsObject(cx, newScope, e.getValue()), e);
                }
            }
            finally {
                Context.exit();
            }
        }

        private String debugJsObject(Context cx, Scriptable scope, Object value) {
            Object v;
            Scriptable obj;
            if (value instanceof Scriptable && ScriptableObject.hasProperty((Scriptable)(obj = (Scriptable)value), (String)"toSource") && (v = ScriptableObject.getProperty((Scriptable)obj, (String)"toSource")) instanceof Function) {
                Function f = (Function)v;
                return String.valueOf(f.call(cx, scope, obj, new Object[0]));
            }
            return String.valueOf(value);
        }
    }

    private class CachingDevModeLessResource
    extends DevModeLessResource {
        private final String cacheKey;
        private final DevModeCache cache;

        CachingDevModeLessResource(DevModeCache devModeCache, String pluginKey, ResourceLocation originalLocation, DownloadableResource originalResource, boolean minificationDisabled) {
            super(pluginKey, originalLocation, originalResource, minificationDisabled);
            this.cache = devModeCache;
            this.cacheKey = pluginKey + ":" + originalLocation.getLocation();
        }

        @Override
        protected CharSequence transform(CharSequence originalContent) {
            CharSequence result = this.cache.get(this.cacheKey, originalContent);
            if (result == null) {
                result = super.transform(originalContent);
                this.cache.put(this.cacheKey, this.loader.dependencies, result);
            }
            return result;
        }
    }

    private class DevModeLessResource
    extends LessResource {
        DevModeLessResource(String pluginKey, ResourceLocation originalLocation, DownloadableResource originalResource, boolean minificationDisabled) {
            super(pluginKey, originalLocation, originalResource, minificationDisabled);
        }

        @Override
        protected CharSequence transform(CharSequence originalContent) {
            return "/*\n * Name: " + this.getOriginalLocation().getName() + "\n * File: " + this.getOriginalLocation().getLocation() + "\n */\n\n" + super.transform(originalContent);
        }
    }

    public class LessResource
    extends CharSequenceDownloadableResource {
        protected final String pluginKey;
        protected final ResourceLocation originalLocation;
        protected final BaseLoader loader;
        private final boolean minificationDisabled;
        private final String locationUri;

        private LessResource(String pluginKey, ResourceLocation originalLocation, DownloadableResource originalResource, boolean minificationDisabled) {
            super(originalResource);
            this.pluginKey = pluginKey;
            this.originalLocation = originalLocation;
            this.minificationDisabled = minificationDisabled;
            this.loader = new BaseLoader();
            String sourceParam = originalLocation.getParameter("source");
            this.locationUri = "webContextStatic".equalsIgnoreCase(sourceParam) ? "webstatic:/" + LessTransformer.this.stripLeadingSlash(originalLocation.getLocation()) : "plugin://" + pluginKey + "/" + LessTransformer.this.stripLeadingSlash(originalLocation.getLocation());
        }

        public String getContentType() {
            return "text/css";
        }

        protected CharSequence transform(CharSequence originalContent) {
            InlineImageEncoder.setLoader(this.loader);
            this.loader.dependencies.addOriginalContent(originalContent);
            String result = ((LessCompiler)LESSC.get()).compile(this.locationUri, this.loader, ((Object)originalContent).toString(), !this.minificationDisabled);
            InlineImageEncoder.setLoader(null);
            return result;
        }

        protected ResourceLocation getOriginalLocation() {
            return this.originalLocation;
        }

        public class BaseLoader {
            public final DependencyTracker dependencies;

            public BaseLoader() {
                this.dependencies = new DependencyTracker(LessTransformer.this.isDevMode());
            }

            public String resolve(String relpath, String path) throws URISyntaxException {
                URI destUri = new URI(relpath).resolve(path);
                return destUri.toString();
            }

            public String load(String url) throws URISyntaxException, IOException {
                String result = this.loadUri(new URI(url));
                if (LessTransformer.this.isDevMode()) {
                    result = String.format("/* START %s */\n%s\n/* END %s */\n", url, result, url);
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String loadUri(URI uri) throws IOException {
                String string;
                if ("dynamic".equals(uri.getScheme())) {
                    String special = uri.getSchemeSpecificPart();
                    if ("lookandfeel.less".equals(special)) {
                        this.dependencies.add(new LookAndFeelUptodateCheck());
                        return LessTransformer.this.makeLookAndFeelLess();
                    }
                    throw new FileNotFoundException("Unknown dynamic: special - " + special);
                }
                URL resourceUrl = this.getResourceUrl(uri);
                InputStream in = null;
                try {
                    URLConnection connection = resourceUrl.openConnection();
                    in = connection.getInputStream();
                    if (in == null) {
                        throw new FileNotFoundException("Could not find resource: " + uri + ", from " + resourceUrl);
                    }
                    this.dependencies.add(new URLUptodateCheck(connection.getLastModified(), resourceUrl));
                    string = IOUtils.toString((InputStream)in);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                return string;
            }

            public URL getResourceUrl(URI uri) throws IOException {
                URL resourceUrl;
                if ("webstatic".equals(uri.getScheme())) {
                    String path = uri.getSchemeSpecificPart();
                    resourceUrl = LessTransformer.this.servletContextFactory.getServletContext().getResource(path);
                } else if ("plugin".equals(uri.getScheme())) {
                    Plugin plugin = LessTransformer.this.pluginAccessor.getPlugin(uri.getHost());
                    if (plugin == null) {
                        throw new IllegalStateException("Cannot load resource because could not find plugin plugin=" + LessResource.this.pluginKey);
                    }
                    resourceUrl = plugin.getResource(uri.getPath());
                } else {
                    throw new FileNotFoundException("Could not find resource: " + uri);
                }
                return resourceUrl;
            }

            public URI resolveAbsoluteURI(String path) throws URISyntaxException {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                return new URI(LessResource.this.locationUri).resolve(path);
            }
        }
    }
}

