/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.accesslog;

import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.ofbiz.PerformanceSQLInterceptor;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.web.filters.accesslog.AccessLogBuilder;
import com.atlassian.jira.web.filters.accesslog.AccessLogRequestInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class AccessLogImprinter {
    public static final String REQUEST_SQL_CACHE_STORAGE = "request.sql.cache.storage";
    private static final int LEFT_PAD = 30;
    private static final int MAX_NUM_REQUESTS = 50;
    private final HttpServletRequest httpServletRequest;

    public AccessLogImprinter(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public String imprintHTMLComment() {
        Long startMS = (Long)this.httpServletRequest.getAttribute("jira.request.start.millis");
        Long responseTimeMS = startMS == null ? null : Long.valueOf(System.currentTimeMillis() - startMS);
        DateTime requestTimeStamp = startMS == null ? null : new DateTime((Object)startMS);
        StringBuilder comment = new StringBuilder().append("\n\t").append(StringUtils.leftPad((String)"REQUEST ID : ", (int)30)).append(AccessLogBuilder.enc(this.httpServletRequest.getAttribute("jira.request.id"))).append("\n\t").append(StringUtils.leftPad((String)"REQUEST TIMESTAMP : ", (int)30)).append(AccessLogBuilder.getDateString((ReadableInstant)requestTimeStamp)).append("\n\t").append(StringUtils.leftPad((String)"REQUEST TIME : ", (int)30)).append(AccessLogBuilder.enc(AccessLogBuilder.formatMStoDecimalSecs(responseTimeMS))).append("\n\t").append(StringUtils.leftPad((String)"ASESSIONID : ", (int)30)).append(AccessLogBuilder.enc(this.httpServletRequest.getAttribute("jira.request.assession.id"))).append("\n\t").append(StringUtils.leftPad((String)"CONCURRENT REQUESTS : ", (int)30)).append(AccessLogBuilder.enc(AccessLogRequestInfo.concurrentRequests));
        this.imprintIntrumentationHTMLComment(comment);
        return "\n<!--" + this.htmlCommentEsc(comment.toString()) + "\n-->";
    }

    private void imprintIntrumentationHTMLComment(StringBuilder comment) {
        List<OpSnapshot> opSnapshots = Instrumentation.snapshotThreadLocalOperationsAndClear((OpTimerFactory)ComponentAccessor.getComponent(OpTimerFactory.class));
        comment.append("\n");
        for (OpSnapshot opSnapshot : opSnapshots) {
            comment.append("\n\t").append(StringUtils.leftPad((String)opSnapshot.getName(), (int)30)).append(" : ").append(opSnapshot.toString());
        }
    }

    public String imprintHiddenHtml() {
        Long startMS = (Long)this.httpServletRequest.getAttribute("jira.request.start.millis");
        Long responseTimeMS = startMS == null ? null : Long.valueOf(System.currentTimeMillis() - startMS);
        Long sessionLastAccess = (Long)this.httpServletRequest.getAttribute("jira.session.last.accessed.time");
        Integer sessionMaxInactiveInterval = (Integer)this.httpServletRequest.getAttribute("jira.session.max.inactive.interval");
        Long expiryTime = this.calculateSessionExpiry(sessionLastAccess, sessionMaxInactiveInterval);
        Long expiresIn = this.calculateSessionExpiresIn(expiryTime);
        StringBuilder builder = new StringBuilder("\n<form id=\"jira_request_timing_info\" class=\"dont-default-focus\" >");
        builder.append("\n\t<fieldset class=\"parameters hidden\">").append("\n\t\t").append(this.hiddenInput("jira.request.start.millis", AccessLogBuilder.enc(startMS))).append("\n\t\t").append(this.hiddenInput("jira.request.server.time", AccessLogBuilder.enc(responseTimeMS))).append("\n\t\t").append(this.hiddenInput("jira.request.id", AccessLogBuilder.enc(this.httpServletRequest.getAttribute("jira.request.id")))).append("\n\t\t").append(this.hiddenInput("jira.session.expiry.time", AccessLogBuilder.enc(expiryTime))).append("\n\t\t").append(this.hiddenInput("jira.session.expiry.in.mins", AccessLogBuilder.enc(expiresIn))).append("\n\t\t").append(this.hiddenInput("jiraConcurrentRequests", "jira.request.concurrent.requests", AccessLogBuilder.enc(AccessLogRequestInfo.concurrentRequests)));
        if (JiraSystemProperties.showPerformanceMonitor()) {
            PerformanceSQLInterceptor.SQLPerfCache perfCache = (PerformanceSQLInterceptor.SQLPerfCache)JiraAuthenticationContextImpl.getRequestCache().get("sql.perf.cache");
            if (perfCache != null) {
                builder.append("\n\t\t").append(this.hiddenInput("jiraSQLtime", AccessLogBuilder.enc(perfCache.getTotalTimeMs()))).append("\n\t\t").append(this.hiddenInput("jiraSQLstatements", AccessLogBuilder.enc(perfCache.getNumStatements())));
                this.recordSQLdataInSession(perfCache);
            }
            builder.append("\n\t\t").append(this.hiddenInput("showmonitor", "true"));
        }
        builder.append("\n\t</fieldset>").append("\n</form>");
        return builder.toString();
    }

    private void recordSQLdataInSession(PerformanceSQLInterceptor.SQLPerfCache perfCache) {
        HttpSession session = this.httpServletRequest.getSession(false);
        if (session != null) {
            Map storage = (Map)session.getAttribute(REQUEST_SQL_CACHE_STORAGE);
            if (storage == null) {
                storage = new LinkedHashMap<String, PerformanceSQLInterceptor.SQLPerfCache>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry eldest) {
                        return this.size() > 50;
                    }
                };
                session.setAttribute(REQUEST_SQL_CACHE_STORAGE, (Object)storage);
            }
            storage.put((String)this.httpServletRequest.getAttribute("jira.request.id"), perfCache);
        }
    }

    private Long calculateSessionExpiry(Long sessionLastAccess, Integer sessionMaxInactiveInterval) {
        if (sessionLastAccess == null || sessionMaxInactiveInterval == null) {
            return null;
        }
        return sessionLastAccess + (long)(sessionMaxInactiveInterval * 1000);
    }

    private Long calculateSessionExpiresIn(Long expiryTime) {
        return expiryTime == null ? null : Long.valueOf((expiryTime - System.currentTimeMillis()) / 1000L / 60L);
    }

    private String hiddenInput(String name, String value) {
        return "<input type=\"hidden\" title=\"" + name + "\" value=\"" + value + "\" />";
    }

    private String hiddenInput(String id, String name, String value) {
        return "<input id=\"" + id + "\" type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\" />";
    }

    private String htmlCommentEsc(String comment) {
        if (comment.contains("--")) {
            return comment.replaceAll("--", "-:");
        }
        return comment;
    }
}

