/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.jira.web.component.ModuleWebComponentFields;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleWebComponentImpl
implements ModuleWebComponent {
    private static final Logger log = LoggerFactory.getLogger(ModuleWebComponentImpl.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ModuleWebComponentFields mwcFields;

    public ModuleWebComponentImpl(JiraAuthenticationContext jiraAuthenticationContext, ModuleWebComponentFields mwcFields) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.mwcFields = mwcFields;
    }

    @Override
    public String renderModules(User user, HttpServletRequest request, List<WebPanelModuleDescriptor> webPanelModuleDescriptors, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        for (WebPanelModuleDescriptor webPanelModuleDescriptor : webPanelModuleDescriptors) {
            this.renderModuleAndLetNoThrowablesEscape(sb, user, request, webPanelModuleDescriptor, params);
        }
        return sb.toString();
    }

    @Override
    public String renderModule(User user, HttpServletRequest request, WebPanelModuleDescriptor webPanelModuleDescriptor, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        this.renderModuleAndLetNoThrowablesEscape(sb, user, request, webPanelModuleDescriptor, params);
        return sb.toString();
    }

    private void renderModuleAndLetNoThrowablesEscape(StringBuilder module, User user, HttpServletRequest request, WebPanelModuleDescriptor webPanelModuleDescriptor, Map<String, Object> params) {
        try {
            this.renderModule(module, user, request, webPanelModuleDescriptor, params);
        }
        catch (Exception webPanelRenderException) {
            log.error("An exception occured while rendering the web panel: " + webPanelModuleDescriptor, (Throwable)webPanelRenderException);
            module.append(this.buildRenderFailureMessage(webPanelModuleDescriptor));
        }
    }

    private void renderModule(StringBuilder module, User user, HttpServletRequest request, WebPanelModuleDescriptor webPanelModuleDescriptor, Map<String, Object> params) throws SoyException {
        String prefix;
        String additionalContainerClass;
        String html;
        try {
            html = ((WebPanel)webPanelModuleDescriptor.getModule()).getHtml(params);
        }
        catch (Exception webPanelRenderException) {
            log.error("An exception occured while rendering the web panel: " + webPanelModuleDescriptor, (Throwable)webPanelRenderException);
            html = this.buildRenderFailureMessage(webPanelModuleDescriptor);
        }
        JiraHelper helper = (JiraHelper)params.get("helper");
        if (StringUtils.isBlank((String)html)) {
            return;
        }
        Map moduleParams = webPanelModuleDescriptor.getParams();
        if (moduleParams.containsKey("headless") && ((String)moduleParams.get("headless")).equals("true") || params.containsKey("headless") && params.get("headless").equals(true)) {
            module.append(html);
            return;
        }
        String key = webPanelModuleDescriptor.getKey();
        String string = additionalContainerClass = moduleParams.containsKey("containerClass") ? " " + (String)moduleParams.get("containerClass") : "";
        if (StringUtils.isBlank((String)additionalContainerClass)) {
            additionalContainerClass = params.containsKey("containerClass") ? " " + params.get("containerClass") : "";
        }
        String string2 = prefix = moduleParams.containsKey("prefix") ? "" + (String)moduleParams.get("prefix") : "";
        if (StringUtils.isBlank((String)prefix)) {
            prefix = params.containsKey("prefix") ? "" + params.get("prefix") : "";
        }
        HashMap<String, Object> data = new HashMap<String, Object>(params);
        data.put("id", prefix + key);
        data.put("headerId", key + "_heading");
        data.put("headerActionsContent", this.renderHeaderActions(user, webPanelModuleDescriptor, helper));
        data.put("headerPanelContent", this.renderHeaderPanels(webPanelModuleDescriptor.getCompleteKey(), params));
        data.put("headingContent", this.renderModHeading(request, webPanelModuleDescriptor, params));
        data.put("content", html);
        data.put("headingLevel", 2);
        data.put("extraClasses", additionalContainerClass);
        module.append(this.getSoyRenderer().render("jira.webresources:soy-templates", "JIRA.Templates.Modules.module", data));
    }

    private String renderHeaderActions(User user, WebPanelModuleDescriptor webPanelModuleDescriptor, JiraHelper helper) {
        StringBuilder sb = new StringBuilder();
        this.renderHeaderActions(sb, user, webPanelModuleDescriptor, helper);
        return sb.toString();
    }

    private void renderHeaderActions(StringBuilder module, User user, WebPanelModuleDescriptor webPanelModuleDescriptor, JiraHelper helper) {
        List<SimpleLink> headerItems = this.mwcFields.getHeaderItems(webPanelModuleDescriptor.getCompleteKey(), user, helper);
        List<ModuleWebComponentFields.SectionsAndLinks> dropDownSections = this.mwcFields.getDropdownSections(webPanelModuleDescriptor.getCompleteKey(), user, helper);
        if (!headerItems.isEmpty() || !dropDownSections.isEmpty()) {
            StringBuilder headerOps = new StringBuilder();
            headerOps.append("<ul class='ops'>");
            for (SimpleLink link : headerItems) {
                headerOps.append("<li>");
                this.renderLink(headerOps, link, "");
                headerOps.append("</li>");
            }
            if (!dropDownSections.isEmpty()) {
                headerOps.append("<li class='drop'>");
                headerOps.append("<div class='aui-dd-parent'>");
                String optionText = this.jiraAuthenticationContext.getI18nHelper().getText("admin.common.words.options");
                headerOps.append("<a href='#' class='icon drop-menu js-default-dropdown' title='").append(optionText).append("'><span>").append(optionText).append("</span></a>");
                headerOps.append("<div class='aui-dropdown-content aui-list'>");
                for (int i = 0; i < dropDownSections.size(); ++i) {
                    String additionalClass = "";
                    if (i == 0) {
                        additionalClass = "aui-first";
                    }
                    if (i == dropDownSections.size() - 1) {
                        additionalClass = additionalClass + " aui-last";
                    }
                    ModuleWebComponentFields.SectionsAndLinks sectionAndLinks = dropDownSections.get(i);
                    this.renderSection(headerOps, sectionAndLinks.getSection(), additionalClass, sectionAndLinks.getLinks());
                }
                headerOps.append("</div>");
                headerOps.append("</div>");
                headerOps.append("</li>");
            }
            headerOps.append("</ul>");
            module.append((CharSequence)headerOps);
        }
    }

    private String renderHeaderPanels(String key, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        this.renderHeaderPanels(sb, key, params);
        return sb.toString();
    }

    private void renderHeaderPanels(StringBuilder sb, String key, Map<String, Object> params) {
        List<WebPanelModuleDescriptor> panels = this.mwcFields.getPanels(key, params);
        if (!panels.isEmpty()) {
            sb.append("<div class='mod-header-panels'>");
            for (WebPanelModuleDescriptor panel : panels) {
                sb.append("<div class='mod-header-panel'>");
                sb.append(((WebPanel)panel.getModule()).getHtml(params));
                sb.append("</div>");
            }
            sb.append("</div>");
        }
    }

    private String renderSection(SimpleLinkSection section, String additionalClass, List<SimpleLink> links) {
        StringBuilder sb = new StringBuilder();
        this.renderSection(sb, section, additionalClass, links);
        return sb.toString();
    }

    private void renderSection(StringBuilder sb, SimpleLinkSection section, String additionalClass, List<SimpleLink> links) {
        if (StringUtils.isNotBlank((String)section.getLabel())) {
            sb.append("<h5>").append(section.getLabel()).append("</h5>");
        }
        sb.append("<ul");
        if (StringUtils.isNotBlank((String)section.getId())) {
            sb.append(" id='").append(section.getId()).append("'");
        }
        sb.append(" class='aui-list-section");
        if (StringUtils.isNotBlank((String)additionalClass)) {
            sb.append(" ").append(additionalClass);
        }
        if (StringUtils.isNotBlank((String)section.getStyleClass())) {
            sb.append(" ").append(section.getStyleClass());
        }
        sb.append("'>");
        for (SimpleLink link : links) {
            sb.append("<li class='aui-list-item'>");
            this.renderLink(sb, link, "aui-list-item-link");
            sb.append("</li>");
        }
        sb.append("</ul>");
    }

    private String renderLink(SimpleLink link, String additionalClass) {
        StringBuilder sb = new StringBuilder();
        this.renderLink(sb, link, additionalClass);
        return sb.toString();
    }

    private void renderLink(StringBuilder sb, SimpleLink link, String additionalClass) {
        sb.append("<a");
        if (StringUtils.isNotBlank((String)link.getId())) {
            sb.append(" id='").append(link.getId()).append("'");
        }
        sb.append(" href='").append(link.getUrl()).append("'");
        if (StringUtils.isNotBlank((String)link.getStyleClass()) || StringUtils.isNotBlank((String)additionalClass)) {
            sb.append(" class='");
            if (StringUtils.isNotBlank((String)link.getStyleClass())) {
                sb.append(link.getStyleClass());
            }
            sb.append(" ").append(additionalClass);
            sb.append("'");
        }
        if (StringUtils.isNotBlank((String)link.getTitle())) {
            sb.append(" title='").append(link.getTitle()).append("'");
        }
        sb.append("><span>");
        sb.append(link.getLabel());
        sb.append("</span></a>");
    }

    @HtmlSafe
    private String renderModHeading(HttpServletRequest request, WebPanelModuleDescriptor webPanel, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        this.renderModHeading(sb, request, webPanel, params);
        return TextUtils.htmlEncode((String)sb.toString());
    }

    private void renderModHeading(StringBuilder sb, HttpServletRequest request, WebPanelModuleDescriptor webPanel, Map<String, Object> params) {
        try {
            WebLabel webLabel = webPanel.getWebLabel();
            if (webLabel != null) {
                sb.append(webLabel.getDisplayableLabel(request, params));
            }
        }
        catch (Exception labelRenderException) {
            if (webPanel.getI18nNameKey() != null) {
                sb.append(this.jiraAuthenticationContext.getI18nHelper().getText(webPanel.getI18nNameKey()));
            }
            sb.append(webPanel.getKey());
        }
    }

    private String buildRenderFailureMessage(WebPanelModuleDescriptor webPanelModuleDescriptor) {
        return this.jiraAuthenticationContext.getI18nHelper().getText("modulewebcomponent.exception", webPanelModuleDescriptor.getCompleteKey());
    }

    protected SoyTemplateRenderer getSoyRenderer() {
        return ComponentManager.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
    }
}

