/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean.i18n;

import com.atlassian.jira.web.bean.i18n.ByteArray;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

final class CompressedKey {
    private static final Interner<CompressedKey> WORD_INTERNER = Interners.newWeakInterner();
    private static final CompressedKey ROOT = new CompressedKey(null, null);
    private final CompressedKey parent;
    private final ByteArray word;
    private int hash;

    public static CompressedKey fromString(@Nullable String string) {
        String[] words;
        if (string == null) {
            return null;
        }
        CompressedKey compressedKey = ROOT;
        for (String word : words = StringUtils.split((String)string, (String)".")) {
            compressedKey = (CompressedKey)WORD_INTERNER.intern((Object)new CompressedKey(compressedKey, ByteArray.fromString(word)));
        }
        return compressedKey;
    }

    CompressedKey(CompressedKey parent, ByteArray word) {
        this.parent = parent;
        this.word = word;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        CompressedKey.appendWords(sb, this);
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressedKey compressedKey = (CompressedKey)o;
        if (this.parent != null ? !this.parent.equals(compressedKey.parent) : compressedKey.parent != null) {
            return false;
        }
        return !(this.word != null ? !this.word.equals(compressedKey.word) : compressedKey.word != null);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this != ROOT) {
            h = this.parent.hashCode();
            this.hash = h = 31 * h + (this.word != null ? this.word.hashCode() : 0);
        }
        return h;
    }

    @VisibleForTesting
    CompressedKey parent() {
        return this.parent;
    }

    private static void appendWords(StringBuilder sb, CompressedKey compressedKey) {
        if (compressedKey != ROOT) {
            CompressedKey.appendWords(sb, compressedKey.parent);
            sb.append(compressedKey.word).append('.');
        }
    }
}

