/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.plugin.issueview.IssueViewFieldParams;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CustomIssueXMLViewFieldsBean {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final IssueViewFieldParams issueViewFieldParams;
    private final Long projectId;
    private final String issueTypeId;
    private final Set<String> timetrackingFieldIds;

    public CustomIssueXMLViewFieldsBean(FieldVisibilityManager fieldVisibilityManager, IssueViewFieldParams issueViewFieldParams, Long projectId, String issueTypeId) {
        this.projectId = projectId;
        this.issueTypeId = issueTypeId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.issueViewFieldParams = issueViewFieldParams;
        HashSet<String> fieldIds = new HashSet<String>();
        fieldIds.add("timeoriginalestimate");
        fieldIds.add("timeestimate");
        fieldIds.add("timespent");
        fieldIds.add("aggregatetimeoriginalestimate");
        fieldIds.add("aggregatetimeestimate");
        fieldIds.add("aggregatetimespent");
        this.timetrackingFieldIds = Collections.unmodifiableSet(fieldIds);
    }

    public boolean isFieldRequestedAndVisible(String fieldId) {
        boolean visible = false;
        if (this.issueViewFieldParams.isCustomViewRequested()) {
            if (this.issueViewFieldParams.getFieldIds().contains(fieldId)) {
                visible = this.checkFieldVisible(fieldId, this.projectId, this.issueTypeId);
            }
        } else {
            visible = this.checkFieldVisible(fieldId, this.projectId, this.issueTypeId);
        }
        return visible;
    }

    private boolean checkFieldVisible(String fieldId, Long projectId, String issueTypeId) {
        if ("attachment".equals(fieldId)) {
            return true;
        }
        if (this.timetrackingFieldIds.contains(fieldId)) {
            return this.fieldVisibilityManager.isFieldVisible(projectId, "timetracking", issueTypeId);
        }
        if (this.issueViewFieldParams.getOrderableFieldIds().contains(fieldId)) {
            return this.fieldVisibilityManager.isFieldVisible(projectId, fieldId, issueTypeId);
        }
        return true;
    }
}

