/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Collection;
import java.util.HashSet;

public class ShowConstantsHelp
extends JiraWebActionSupport {
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final PermissionManager permissionManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final StatusCategoryManager statusCategoryManager;

    public ShowConstantsHelp(ConstantsManager constantsManager, SubTaskManager subTaskManager, PermissionManager permissionManager, IssueSecurityLevelManager issueSecurityLevelManager, StatusCategoryManager statusCategoryManager) {
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
        this.permissionManager = permissionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.statusCategoryManager = statusCategoryManager;
    }

    protected String doExecute() throws Exception {
        if (!this.permissionManager.hasProjects(10, this.getLoggedInUser())) {
            return "error";
        }
        return super.doExecute();
    }

    public boolean isSubTasksEnabled() {
        return this.subTaskManager.isSubTasksEnabled();
    }

    public Collection getIssueTypes() {
        return this.constantsManager.getIssueTypes();
    }

    public IssueType getIssueType(String id) {
        return this.constantsManager.getIssueTypeObject(id);
    }

    public Collection getSubTaskIssueTypes() {
        if (!this.isSubTasksEnabled()) {
            throw new IllegalStateException("Should not call this method as subtasks are disabled");
        }
        return this.constantsManager.getSubTaskIssueTypes();
    }

    public Collection getPriorities() {
        return this.constantsManager.getPriorityObjects();
    }

    public Collection getStatuses() {
        return this.constantsManager.getStatusObjects();
    }

    public boolean isStatusCategoriesEnabled() {
        return this.statusCategoryManager.isStatusAsLozengeEnabled();
    }

    public Collection<SimpleStatus> getStatusCategories() {
        if (!this.isStatusCategoriesEnabled()) {
            throw new IllegalStateException("Should not call this method as subtasks are disabled");
        }
        HashSet<SimpleStatus> categories = new HashSet<SimpleStatus>();
        for (StatusCategory category : this.statusCategoryManager.getStatusCategories()) {
            categories.add(new SimpleStatusImpl(null, this.getNameTranslation(category), this.getDescTranslation(category), category, null));
        }
        return categories;
    }

    public Collection getResolutions() {
        return this.constantsManager.getResolutionObjects();
    }

    public Collection<IssueSecurityLevel> getSecurityLevels() {
        return this.issueSecurityLevelManager.getUsersSecurityLevels(this.getSelectedProjectObject(), this.getLoggedInUser());
    }

    private String getNameTranslation(StatusCategory category) {
        return this.getText("common.statuscategory." + category.getKey());
    }

    private String getDescTranslation(StatusCategory category) {
        return this.getText("common.statuscategory." + category.getKey() + ".description");
    }
}

