/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.profile.OptionalUserProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSectionImpl;
import com.atlassian.jira.plugin.webresource.SuperBatchFilteringWriter;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.AbstractPluggableTabPanelAction;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import webwork.action.ServletActionContext;

public class ViewProfile
extends AbstractPluggableTabPanelAction<ViewProfilePanelModuleDescriptor> {
    private static final String CONTENTONLY = "contentonly";
    private static final String JSON_CONTENT = "json";
    private String name;
    private User profileUser;
    private static final String USER_NOT_FOUND_VIEW = "usernotfound";
    private final SimpleLinkManager simpleLinkManager;
    private final WebResourceManager webResourceManager;
    private final UserPropertyManager userPropertyManager;
    protected final CrowdService crowdService;
    private final AvatarService avatarService;
    private final UserHistoryManager userHistoryManager;
    private boolean contentOnly = false;
    private boolean asJson = false;
    private boolean noTitle = false;
    private ViewProfilePanelModuleDescriptor selectedDescriptor = null;

    public ViewProfile(UserPropertyManager userPropertyManager) {
        this((SimpleLinkManager)ComponentAccessor.getComponentOfType(SimpleLinkManager.class), (WebResourceManager)ComponentAccessor.getComponentOfType(WebResourceManager.class), (PluginAccessor)ComponentAccessor.getComponentOfType(PluginAccessor.class), (CrowdService)ComponentAccessor.getComponentOfType(CrowdService.class), userPropertyManager, (AvatarService)ComponentAccessor.getComponentOfType(AvatarService.class), (UserHistoryManager)ComponentAccessor.getComponentOfType(UserHistoryManager.class));
    }

    public ViewProfile(SimpleLinkManager SimpleLinkManager2, WebResourceManager webResourceManager, PluginAccessor pluginAccessor, CrowdService crowdService, UserPropertyManager userPropertyManager, AvatarService avatarService, UserHistoryManager userHistoryManager) {
        super(pluginAccessor);
        super.setPersistenceKey("jira.view.profile.tab");
        this.simpleLinkManager = SimpleLinkManager2;
        this.webResourceManager = webResourceManager;
        this.crowdService = crowdService;
        this.userPropertyManager = userPropertyManager;
        this.avatarService = avatarService;
        this.userHistoryManager = userHistoryManager;
    }

    protected String doExecute() throws Exception {
        this.parseAcceptsHeader();
        if (this.getLoggedInUser() == null) {
            if (this.contentOnly) {
                ServletActionContext.getResponse().setStatus(401);
                return "none";
            }
            return "securitybreach";
        }
        if (this.getUser() == null) {
            if (this.contentOnly) {
                ServletActionContext.getResponse().setStatus(401);
                return "none";
            }
            return USER_NOT_FOUND_VIEW;
        }
        if (this.getUser() != null) {
            this.userHistoryManager.addUserToHistory(UserHistoryItem.ASSIGNEE, this.getLoggedInApplicationUser(), ApplicationUsers.from((User)this.getUser()));
        }
        if (this.contentOnly) {
            if (this.canSeeTab(this.getSelectedTab())) {
                return this.asJson ? JSON_CONTENT : CONTENTONLY;
            }
            ServletActionContext.getResponse().setStatus(401);
            return "none";
        }
        this.webResourceManager.requireResourcesForContext("atl.userprofile");
        this.webResourceManager.requireResourcesForContext("jira.userprofile");
        this.webResourceManager.requireResource("jira.webresources:userprofile");
        return super.doExecute();
    }

    private void parseAcceptsHeader() {
        String accepts = StringUtils.defaultString((String)this.request.getHeader("Accept")).toLowerCase();
        if (accepts.contains("application/json")) {
            this.asJson = true;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean isNoTitle() {
        String NO_TITLE = "noTitle";
        boolean descriptorNoTitle = this.getSelectedProfilePanelDescriptor().getParams().containsKey("noTitle") && "true".equalsIgnoreCase((String)this.getSelectedProfilePanelDescriptor().getParams().get("noTitle"));
        return this.noTitle || descriptorNoTitle;
    }

    public void setNoTitle(boolean noTitle) {
        this.noTitle = noTitle;
    }

    public String getAvatarUrl(User user) {
        if (user != null) {
            return this.avatarService.getAvatarURL(this.getLoggedInApplicationUser(), ApplicationUsers.from((User)user)).toString();
        }
        return null;
    }

    public User getUser() {
        if (this.profileUser == null) {
            this.profileUser = this.name == null ? this.getLoggedInUser() : this.crowdService.getUser(this.name);
        }
        return this.profileUser;
    }

    public ViewProfilePanelModuleDescriptor getSelectedProfilePanelDescriptor() {
        return (ViewProfilePanelModuleDescriptor)this.getSelectedTabPanel();
    }

    public String getLabelForSelectedTab() {
        ViewProfilePanelModuleDescriptor moduleDescriptor = this.getSelectedProfilePanelDescriptor();
        return moduleDescriptor.getName();
    }

    public String getHtmlForSelectedTab() {
        ViewProfilePanelModuleDescriptor moduleDescriptor = this.getSelectedProfilePanelDescriptor();
        String tabHtml = ((ViewProfilePanel)moduleDescriptor.getModule()).getHtml(this.profileUser);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(tabHtml);
        if (this.contentOnly) {
            SuperBatchFilteringWriter writer = new SuperBatchFilteringWriter();
            this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
            strBuilder.append(writer.toString());
        }
        return strBuilder.toString();
    }

    public String getTabHtmlForJSON() throws IOException {
        String tabPanelHTML = this.getHtmlForSelectedTab();
        return JSONEscaper.escape((String)tabPanelHTML);
    }

    public boolean isHasMoreThanOneProfileTabs() {
        return this.getTabDescriptors().size() > 1;
    }

    @Override
    protected boolean canSeeTab(String key) {
        for (ViewProfilePanelModuleDescriptor descriptor : this.getTabPanels()) {
            if (!descriptor.getCompleteKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<ViewProfilePanelModuleDescriptor> getTabPanelModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ViewProfilePanelModuleDescriptor.class);
    }

    @Override
    protected boolean isTabPanelHidden(ViewProfilePanelModuleDescriptor descriptor) throws PermissionException {
        return false;
    }

    public List<ViewProfilePanelModuleDescriptor> getTabDescriptors() {
        return this.getTabPanels();
    }

    @Override
    protected List<ViewProfilePanelModuleDescriptor> initTabPanels() {
        List allDescriptors = super.initTabPanels();
        ArrayList<ViewProfilePanelModuleDescriptor> moduleDescriptors = new ArrayList<ViewProfilePanelModuleDescriptor>();
        for (ViewProfilePanelModuleDescriptor descriptor : allDescriptors) {
            ViewProfilePanel profilePanel = (ViewProfilePanel)descriptor.getModule();
            if (profilePanel instanceof OptionalUserProfilePanel) {
                OptionalUserProfilePanel optionalPanel = (OptionalUserProfilePanel)profilePanel;
                if (!optionalPanel.showPanel(this.getUser(), this.getLoggedInUser())) continue;
                moduleDescriptors.add(descriptor);
                continue;
            }
            moduleDescriptors.add(descriptor);
        }
        Collections.sort(moduleDescriptors, ModuleDescriptorComparator.COMPARATOR);
        return moduleDescriptors;
    }

    public List<SimpleLinkSection> getSectionsForMenu() {
        ArrayList<SimpleLinkSection> sections = new ArrayList<SimpleLinkSection>();
        sections.add((SimpleLinkSection)new SimpleLinkSectionImpl("operations", this.getText("common.concepts.tools"), null, null, "icon-tools", null));
        return sections;
    }

    public List<SimpleLink> getSectionLinks(String key) {
        User remoteUser = this.getLoggedInUser();
        HttpServletRequest servletRequest = ServletActionContext.getRequest();
        servletRequest.setAttribute("profileUser", (Object)this.getUser());
        Map params = MapBuilder.build((Object)"profileUser", (Object)this.getUser());
        JiraHelper helper = new JiraHelper(servletRequest, null, params);
        return this.simpleLinkManager.getLinksForSection("system.user.profile.links/" + key, remoteUser, helper);
    }
}

