/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class RestoreDefaultDashboard
extends JiraWebActionSupport {
    private final FavouritesService favouritesService;
    private final EmailFormatter emailFormatter;
    private final GroupPermissionChecker groupPermissionChecker;
    private final PortalPageService portalPageService;
    private boolean confirm;
    private String destination;
    private Map<PortalPage, Long> portalPagesFavouritedByOthersWithUserCount;

    public RestoreDefaultDashboard(PortalPageService portalPageService, FavouritesService favouritesService, EmailFormatter emailFormatter, GroupPermissionChecker groupPermissionChecker) {
        this.portalPageService = portalPageService;
        this.favouritesService = favouritesService;
        this.emailFormatter = emailFormatter;
        this.groupPermissionChecker = groupPermissionChecker;
    }

    protected void doValidation() {
        if (!this.confirm) {
            this.addErrorMessage(this.getText("admin.errors.user.confirm.revert.default"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            JiraServiceContext serviceContext = this.getJiraServiceContext();
            User user = this.getLoggedInUser();
            Collection portalPages = this.portalPageService.getOwnedPortalPages(user);
            for (PortalPage portalPage : portalPages) {
                if (this.portalPageService.validateForDelete(serviceContext, portalPage.getId())) {
                    this.portalPageService.deletePortalPage(serviceContext, portalPage.getId());
                }
                if (!this.hasAnyErrors()) continue;
                return "error";
            }
            Collection favouritePortalPages = this.portalPageService.getFavouritePortalPages(user);
            for (PortalPage portalPage : favouritePortalPages) {
                this.favouritesService.removeFavourite(serviceContext, (SharedEntity)portalPage);
                if (!this.hasAnyErrors()) continue;
                return "error";
            }
        }
        return this.getRedirect("Dashboard.jspa");
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getCancelUrl() {
        return "ConfigurePortalPages!default.jspa";
    }

    public boolean isHasViewGroupPermission(String group, User user) {
        return this.groupPermissionChecker.hasViewGroupPermission(group, user);
    }

    public String getDisplayEmail(String email) {
        return this.emailFormatter.formatEmailAsLink(email, this.getLoggedInUser());
    }

    public Map getPortalPagesFavouritedByOthersWithUserCount() {
        if (this.portalPagesFavouritedByOthersWithUserCount == null) {
            Collection requests = this.portalPageService.getPortalPagesFavouritedByOthers(this.getLoggedInApplicationUser());
            this.portalPagesFavouritedByOthersWithUserCount = new LinkedHashMap<PortalPage, Long>(requests.size());
            for (PortalPage portalPage : requests) {
                long numberFavourites = portalPage.getFavouriteCount();
                if (this.favouritesService.isFavourite(this.getLoggedInApplicationUser(), (SharedEntity)portalPage)) {
                    --numberFavourites;
                }
                if (numberFavourites <= 0L) continue;
                this.portalPagesFavouritedByOthersWithUserCount.put(portalPage, numberFavourites);
            }
        }
        return this.portalPagesFavouritedByOthersWithUserCount;
    }
}

