/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.util.Collection;

public abstract class AbstractSetupAction
extends JiraWebActionSupport {
    protected static final String SETUP_ALREADY = "setupalready";
    public static final String DEFAULT_GROUP_ADMINS = "jira-administrators";
    public static final String DEFAULT_GROUP_DEVELOPERS = "jira-developers";
    public static final String DEFAULT_GROUP_USERS = "jira-users";
    protected final FileFactory fileFactory;

    public AbstractSetupAction(FileFactory fileFactory) {
        this.fileFactory = fileFactory;
    }

    public boolean setupAlready() {
        return this.getApplicationProperties().getString("jira.setup") != null;
    }

    protected void validateFormPathParam(String formElement, String blankErrorMessage, String nonUniqueErrorMessage, String myPath, Collection<String> otherPaths) {
        if (!TextUtils.stringSet((String)myPath)) {
            this.addError(formElement, this.getText(blankErrorMessage));
        } else {
            for (String otherPath : otherPaths) {
                if (!myPath.equals(otherPath)) continue;
                this.addError(formElement, this.getText(nonUniqueErrorMessage));
            }
            this.validateSetupPath(myPath, formElement);
        }
    }

    protected void validateSetupPath(String paramPath, String formElement) {
        File attachmentDir = this.fileFactory.getFile(paramPath);
        if (!attachmentDir.isAbsolute()) {
            this.addError(formElement, this.getText("setup.error.filepath.notabsolute"));
        } else if (!attachmentDir.exists()) {
            try {
                if (!attachmentDir.mkdirs()) {
                    this.addError(formElement, this.getText("setup.error.filepath.notexist"));
                }
            }
            catch (Exception e) {
                this.addError(formElement, this.getText("setup.error.filepath.notexist"));
            }
        } else if (!attachmentDir.isDirectory()) {
            this.addError(formElement, this.getText("setup.error.filepath.notdir"));
        } else if (!attachmentDir.canWrite()) {
            this.addError(formElement, this.getText("setup.error.filepath.notwriteable"));
        }
    }
}

