/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.bc.project.index.ProjectIndexTaskContext;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.jira.web.action.project.ViewProject;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.concurrent.ExecutionException;

@WebSudoRequired
public class IndexProject
extends ViewProject {
    private final TaskManager taskManager;
    private final TaskDescriptorBean.Factory taskBeanFactory;
    private final ProjectReindexService projectReindexService;
    private final JiraAuthenticationContext authenticationContext;
    private Long taskId;
    private TaskDescriptorBean<IndexCommandResult> currentTask;
    private long reindexTime = 0L;
    private TaskDescriptor<IndexCommandResult> currentTaskDescriptor;

    public IndexProject(TaskManager taskManager, TaskDescriptorBean.Factory factory, ProjectReindexService projectReindexService, JiraAuthenticationContext authenticationContext) {
        this.taskManager = taskManager;
        this.taskBeanFactory = factory;
        this.projectReindexService = projectReindexService;
        this.authenticationContext = authenticationContext;
    }

    @Override
    protected String doExecute() {
        Project projectObject = this.getProjectObject();
        if (projectObject == null) {
            return this.getRedirect("/plugins/servlet/project-config/UNKNOWN/summary");
        }
        TaskDescriptor<IndexCommandResult> taskDescriptor = this.getCurrentTaskDescriptor();
        if (taskDescriptor != null) {
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        return this.getRedirect(this.projectReindexService.reindex(this.getProjectObject()));
    }

    public String doProgress() throws ExecutionException, InterruptedException {
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.id"));
            return "error";
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.found"));
            return "error";
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof ProjectIndexTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", IndexTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        this.currentTask = this.taskBeanFactory.create(this.currentTaskDescriptor);
        if (this.currentTaskDescriptor.isFinished() && !this.currentTaskDescriptor.isCancelled()) {
            try {
                IndexCommandResult result = this.currentTaskDescriptor.getResult();
                if (result.isSuccessful()) {
                    this.reindexTime = result.getReindexTime();
                } else {
                    this.addErrorCollection(result.getErrorCollection());
                }
            }
            catch (ExecutionException e) {
                this.currentTask.setExceptionCause(e.getCause() == null ? e : e.getCause());
            }
            catch (InterruptedException e) {
                this.currentTask.setExceptionCause(e);
            }
        }
        return "progress";
    }

    public String doCancel() throws ExecutionException, InterruptedException {
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.id"));
            return "error";
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.found"));
            return "error";
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof ProjectIndexTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", ProjectIndexTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        this.currentTaskDescriptor.cancel();
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        this.currentTask = this.taskBeanFactory.create(this.currentTaskDescriptor);
        return "success";
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public long getReindexTime() {
        return this.reindexTime;
    }

    public TaskDescriptorBean<IndexCommandResult> getOurTask() {
        return this.currentTask;
    }

    public TaskDescriptorBean<IndexCommandResult> getCurrentTask() {
        TaskDescriptor<IndexCommandResult> taskDescriptor;
        if (this.currentTask == null && (taskDescriptor = this.getCurrentTaskDescriptor()) != null) {
            this.currentTask = this.taskBeanFactory.create(taskDescriptor);
        }
        return this.currentTask;
    }

    private TaskDescriptor<IndexCommandResult> getCurrentTaskDescriptor() {
        if (this.currentTaskDescriptor == null) {
            this.currentTaskDescriptor = this.taskManager.getLiveTask(new ProjectIndexTaskContext(this.getProjectObject()));
        }
        return this.currentTaskDescriptor;
    }

    public String getDestinationURL() {
        Project projectObject = this.getProjectObject();
        if (projectObject != null) {
            return "/plugins/servlet/project-config/" + projectObject.getKey() + "/summary";
        }
        return "/plugins/servlet/project-config/UNKNOWN/summary";
    }
}

