/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.util;

import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedSet;
import org.apache.log4j.Logger;

public class ScreenTabErrorHelper
implements Serializable {
    private static final Logger log = Logger.getLogger(ScreenTabErrorHelper.class);

    public int initialiseTabsWithErrors(SortedSet<FieldScreenRenderTab> tabsWithErrors, Map<String, ?> errors, FieldScreenRenderer fieldScreenRenderer, Map webParameters) {
        if (errors != null && !errors.isEmpty()) {
            for (String fieldId : errors.keySet()) {
                FieldScreenRenderTab position = fieldId.startsWith("timetracking") || fieldId.startsWith("worklog") ? this.resolvePositionForTimeTrackingAndWorklog(fieldId, fieldScreenRenderer, webParameters) : fieldScreenRenderer.getFieldScreenRenderTabPosition(fieldId);
                if (position == null) continue;
                tabsWithErrors.add(position);
            }
            return tabsWithErrors.first().getPosition() + 1;
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FieldScreenRenderTab resolvePositionForTimeTrackingAndWorklog(String fieldId, FieldScreenRenderer fieldScreenRenderer, Map webParameters) {
        FieldScreenRenderTab timeTrackingTab = fieldScreenRenderer.getFieldScreenRenderTabPosition("timetracking");
        FieldScreenRenderTab worklogTab = fieldScreenRenderer.getFieldScreenRenderTabPosition("worklog");
        if (timeTrackingTab != null && worklogTab != null) {
            if (timeTrackingTab.getPosition() == worklogTab.getPosition()) return timeTrackingTab;
            if (fieldId.startsWith("worklog") || "timetracking_remainingestimate".equals(fieldId)) {
                return worklogTab;
            }
            if ("timetracking_originalestimate".equals(fieldId)) {
                return timeTrackingTab;
            }
            if ("timetracking".equals(fieldId)) {
                boolean hasWorkStarted = this.extractBooleanWebParameter(webParameters, "hasWorkStarted");
                if (!hasWorkStarted) return timeTrackingTab;
                return worklogTab;
            }
        } else {
            if (timeTrackingTab != null) {
                return timeTrackingTab;
            }
            if (worklogTab != null) {
                return worklogTab;
            }
        }
        if (!log.isInfoEnabled()) return null;
        log.info((Object)("Got an error for field '" + fieldId + "' however that field doesn't appear to be on any screen tab."));
        return null;
    }

    private boolean extractBooleanWebParameter(Map webParameters, String paramName) {
        String[] values = (String[])webParameters.get(paramName);
        if (values != null && values.length > 0) {
            return Boolean.valueOf(values[0]);
        }
        return false;
    }
}

