/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.enterprise;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.MoveIssue;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.util.TextUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class MoveIssueUpdateWorkflow
extends MoveIssue {
    private Map subTaskTargetStatusHolder = new HashMap();
    private MutableIssue targetIssue;

    public MoveIssueUpdateWorkflow(SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, UserUtil userUtil) {
        super(subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutManager, issueFactory, fieldScreenRendererFactory, commentService, userUtil);
    }

    @Override
    public String doDefault() {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        if (!this.hasIssuePermission(25, (Issue)this.getIssueObject())) {
            this.addErrorMessage(this.getText("move.issue.nopermissions"));
            return "securitybreach";
        }
        this.getMoveIssueBean().addAvailablePreviousStep(1);
        if (this.isStatusChangeRequired()) {
            this.getMoveIssueBean().setCurrentStep(2);
            return "input";
        }
        this.getMoveIssueBean().setTargetStatusId(this.getCurrentStatusGV().getString("id"));
        return this.forceRedirect("MoveIssueUpdateFields!default.jspa?id=" + this.getIssue().getString("id") + "&assignee=" + URLEncoder.encode("" + this.getAssignee()));
    }

    @Override
    public void doValidation() {
        if (this.getMoveIssueBean() != null) {
            if (!this.hasIssuePermission(25, (Issue)this.getIssueObject())) {
                this.addErrorMessage(this.getText("move.issue.nopermissions"));
                return;
            }
            if (!TextUtils.stringSet((String)this.getTargetStatusId())) {
                this.addErrorMessage(this.getText("admin.errors.issues.select.target.status"));
            }
        }
    }

    @Override
    protected String doExecute() throws WorkflowException {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        if (!this.isSubTask() && this.isHasSubTasks()) {
            this.populatesubTaskTargetStatusHolder();
            this.getMoveIssueBean().setTaskTargetStatusHolder(this.subTaskTargetStatusHolder);
        }
        return this.forceRedirect("MoveIssueUpdateFields!default.jspa?id=" + this.getIssue().getString("id") + "&assignee=" + URLEncoder.encode("" + this.getAssignee()));
    }

    public JiraWorkflow getSubTaskTargetWorkflow(String subTaskTypeID) throws WorkflowException {
        return this.getWorkflowManager().getWorkflow(this.getTargetProject().getLong("id"), subTaskTypeID);
    }

    public Collection getTaskInvalidTypes() throws WorkflowException {
        Collection<GenericValue> subTasks = this.getSubTasks();
        HashSet<GenericValue> invalidTypes = new HashSet<GenericValue>();
        for (GenericValue subTask : subTasks) {
            String taskStatusId = subTask.getString("status");
            String taskTypeId = subTask.getString("type");
            GenericValue taskTypeGV = this.getConstantsManager().getIssueType(taskTypeId);
            GenericValue taskStatusGV = this.getConstantsManager().getStatus(taskStatusId);
            if (!this.getTaskInvalidStatuses(taskTypeId).contains(taskStatusGV)) continue;
            invalidTypes.add(taskTypeGV);
        }
        return invalidTypes;
    }

    public Collection getTargetWorkflows() throws WorkflowException {
        Collection<GenericValue> types = this.getSubTaskTypesUsed();
        ArrayList<JiraWorkflow> workflows = new ArrayList<JiraWorkflow>();
        for (GenericValue type : types) {
            workflows.add(this.getWorkflowForType(this.getTargetPid(), type.getString("id")));
        }
        return workflows;
    }

    public Collection getTaskCurrentWorkflows() throws GenericEntityException, WorkflowException {
        Collection<GenericValue> types = this.getSubTaskTypesUsed();
        ArrayList<JiraWorkflow> workflows = new ArrayList<JiraWorkflow>();
        for (GenericValue type : types) {
            workflows.add(this.getWorkflowForType(this.getProject().getLong("id"), type.getString("id")));
        }
        return workflows;
    }

    public JiraWorkflow getTaskTargetWorkflow(GenericValue taskType) throws WorkflowException {
        return this.getWorkflowForType(this.getTargetPid(), taskType.getString("id"));
    }

    public JiraWorkflow getSubtaskTargetWorkflow(String subtaskIssueType) {
        String targetIssueType = this.getSubtaskTargetIssueType(subtaskIssueType);
        return this.getWorkflowForType(this.getTargetPid(), targetIssueType);
    }

    public JiraWorkflow getTaskCurrentWorkflow(GenericValue taskType) throws GenericEntityException, WorkflowException {
        return this.getWorkflowForType(this.getProject().getLong("id"), taskType.getString("id"));
    }

    public Collection getTasksByStatusWorkflowType(String statusId, JiraWorkflow workflow, String typeId) throws GenericEntityException, WorkflowException {
        Collection<GenericValue> subTasks = this.getSubTasks();
        ArrayList<GenericValue> tasks = new ArrayList<GenericValue>();
        for (GenericValue subTask : subTasks) {
            String taskTypeId = subTask.getString("type");
            JiraWorkflow taskWorkflow = this.getWorkflowForType(this.getProject().getLong("id"), taskTypeId);
            String taskStatusId = subTask.getString("status");
            if (!taskStatusId.equals(statusId) || !taskWorkflow.equals(workflow) || !taskTypeId.equals(typeId)) continue;
            tasks.add(subTask);
        }
        return tasks;
    }

    private void populatesubTaskTargetStatusHolder() throws WorkflowException {
        Map actionParameters = ActionContext.getParameters();
        Collection<GenericValue> subTaskTypesUsed = this.getSubTaskTypesUsed();
        for (GenericValue subTaskTypeGV : subTaskTypesUsed) {
            if (subTaskTypeGV == null) continue;
            String taskTypeId = subTaskTypeGV.getString("id");
            String key = this.getPrefixIssueTypeId(subTaskTypeGV.getString("id"));
            String newIssueType = (String)this.getMoveIssueBean().getFieldValuesHolder().get(key);
            if (newIssueType == null) {
                newIssueType = taskTypeId;
            }
            Collection statuses = this.getTaskInvalidStatuses(taskTypeId);
            String subTaskTypeKey = null;
            String targetStatusId = null;
            for (GenericValue status : statuses) {
                String statusId = status.getString("id");
                subTaskTypeKey = this.getPrefixTaskStatusId(newIssueType, statusId);
                String lookupSubTaskTypeKey = this.getPrefixTaskStatusId(subTaskTypeGV.getString("id"), statusId);
                Object o = actionParameters.get(lookupSubTaskTypeKey);
                if (o instanceof String[]) {
                    String[] strings = (String[])o;
                    targetStatusId = strings[0];
                    continue;
                }
                return;
            }
            this.subTaskTargetStatusHolder.put(subTaskTypeKey, targetStatusId);
        }
    }

    protected Issue getTargetIssueObject() {
        if (this.targetIssue == null) {
            this.targetIssue = this.getIssueManager().getIssueObject(this.getId());
            this.targetIssue.setProjectObject(this.getTargetProjectObj());
            this.targetIssue.setIssueTypeObject(this.getTargetIssueTypeObject());
        }
        return this.targetIssue;
    }

    public String getFieldHtml(FieldLayoutItem fieldLayoutItem) {
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        if (orderableField.isShown(this.getTargetIssueObject())) {
            return orderableField.getCreateHtml(fieldLayoutItem, (OperationContext)this.getMoveIssueBean(), (Action)this, this.getTargetIssueObject());
        }
        return "";
    }
}

