/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.bulkedit.operation.BulkEditOperation;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationDetailsAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.jelly.util.NestedRuntimeException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class BulkEdit
extends AbstractBulkOperationDetailsAction {
    public static final String RADIO_ERROR_MSG = "buik.edit.must.select.one.action.to.perform";
    public static final String SHOW_BULK_EDIT_WARNING = "showBulkEditWarning";
    private BulkEditOperation bulkEditOperation;
    private String[] actions;
    private Map editActions;
    private Map selectedActions;
    ArrayList visibleActions;
    ArrayList hiddenActions;
    private List customFields;
    private final FieldManager fieldManager;
    private final IssueFactory issueFactory;
    private final PermissionManager permissionManager;

    public BulkEdit(SearchService searchService, BulkOperationManager bulkOperationManager, FieldManager fieldManager, IssueFactory issueFactory, PermissionManager permissionManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper) {
        super(searchService, bulkEditBeanSessionHelper);
        this.fieldManager = fieldManager;
        this.bulkEditOperation = (BulkEditOperation)bulkOperationManager.getOperation("bulk.edit.operation.name");
        this.issueFactory = issueFactory;
        this.permissionManager = permissionManager;
    }

    public String getFieldHtml(String fieldId) throws Exception {
        OrderableField orderableField = this.fieldManager.getOrderableField(fieldId);
        Map displayParameters = EasyMap.build((Object)"noHeader", (Object)Boolean.TRUE, (Object)SHOW_BULK_EDIT_WARNING, (Object)Boolean.TRUE);
        return orderableField.getBulkEditHtml((OperationContext)this.getBulkEditBean(), (Action)this, this.getBulkEditBean(), displayParameters);
    }

    public String getFieldViewHtml(OrderableField orderableField) {
        FieldLayoutItem layoutItem = null;
        if (!this.getBulkEditBean().getFieldLayouts().isEmpty()) {
            layoutItem = ((FieldLayout)this.getBulkEditBean().getFieldLayouts().iterator().next()).getFieldLayoutItem(orderableField);
        }
        Map displayParams = MapBuilder.newBuilder((Object)"readonly", (Object)Boolean.TRUE).add((Object)"nolink", (Object)Boolean.TRUE).add((Object)"bulkoperation", (Object)this.getBulkEditBean().getOperationName()).add((Object)"prefix", (Object)"new_").toMutableMap();
        return orderableField.getViewHtml(layoutItem, (Action)this, (Issue)this.getBulkEditBean().getSelectedIssues().iterator().next(), this.getBulkEditBean().getFieldValues().get(orderableField.getId()), displayParams);
    }

    protected Issue getIssueObject(GenericValue issueGV) {
        return this.issueFactory.getIssue(issueGV);
    }

    protected FieldScreenRenderLayoutItem buildFieldScreenRenderLayoutItem(OrderableField field, GenericValue issue) {
        return new FieldScreenRenderLayoutItemImpl(null, this.fieldManager.getFieldLayoutManager().getFieldLayout(issue).getFieldLayoutItem(field));
    }

    @Override
    public String doDetails() {
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        if (bulkEditBean == null) {
            return this.redirectToStart("bulk.edit.session.timeout.message");
        }
        this.setFieldDefaults();
        bulkEditBean.clearAvailablePreviousSteps();
        bulkEditBean.addAvailablePreviousStep(1);
        bulkEditBean.addAvailablePreviousStep(2);
        if (this.isCanDisableMailNotifications()) {
            bulkEditBean.setSendBulkNotification(false);
        } else {
            bulkEditBean.setSendBulkNotification(true);
        }
        this.setCurrentStep(3);
        return "input";
    }

    private void setFieldDefaults() {
        for (Object o : this.getEditActions().values()) {
            BulkEditAction bulkEditAction = (BulkEditAction)o;
            if (!bulkEditAction.isAvailable(this.getBulkEditBean())) continue;
            bulkEditAction.getField().populateDefaults(this.getBulkEditBean().getFieldValuesHolder(), this.getIssueObject(null));
        }
    }

    @Override
    @RequiresXsrfCheck
    public String doDetailsValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.edit.session.timeout.message");
        }
        this.validateInput();
        if (this.invalidInput()) {
            return "error";
        }
        this.updateBean();
        return this.getResult();
    }

    @Override
    @RequiresXsrfCheck
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.edit.session.timeout.message");
        }
        this.doValidationPerform();
        if (this.invalidInput()) {
            return "error";
        }
        try {
            this.getBulkEditOperation().perform(this.getBulkEditBean(), this.getLoggedInApplicationUser());
        }
        catch (Exception e) {
            this.log.error((Object)"Error while performing Bulk Edit operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.edit.perform.error"));
            return "error";
        }
        return this.finishWizard();
    }

    private void doValidationPerform() {
        try {
            if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
                return;
            }
            if (!this.getBulkEditOperation().canPerform(this.getBulkEditBean(), this.getLoggedInApplicationUser())) {
                this.addErrorMessage(this.getText("bulk.edit.cannotperform.error", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
                return;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occurred while testing operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.canperform.error"));
            return;
        }
        try {
            for (BulkEditAction bulkEditAction : this.getBulkEditBean().getActions().values()) {
                if (bulkEditAction.isAvailable(this.getBulkEditBean())) continue;
                this.addErrorMessage(this.getText("bulk.edit.perform.invalid.action", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occurred validating available update operations.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.canperform.error"));
        }
    }

    public String doDefault() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.edit.session.timeout.message");
        }
        this.getBulkEditBean().setIssuesInUse((Collection)this.getBulkEditBean().getSelectedIssues());
        return super.doDefault();
    }

    private void validateInput() {
        if (this.getActions() == null || this.getActions().length == 0) {
            this.addErrorMessage(this.getText(RADIO_ERROR_MSG));
            return;
        }
        this.selectedActions = new HashMap();
        for (int i = 0; i < this.getActions().length; ++i) {
            String fieldId = this.getActions()[i];
            BulkEditAction bulkEditAction = (BulkEditAction)this.getEditActions().get(fieldId);
            this.selectedActions.put(bulkEditAction.getField().getId(), bulkEditAction);
            bulkEditAction.getField().populateFromParams(this.getBulkEditBean().getFieldValuesHolder(), ActionContext.getParameters());
            for (Issue issue : this.getBulkEditBean().getSelectedIssues()) {
                bulkEditAction.getField().validateParams((OperationContext)this.getBulkEditBean(), (ErrorCollection)this, (I18nHelper)this, issue, this.buildFieldScreenRenderLayoutItem(bulkEditAction.getField(), issue.getGenericValue()));
            }
        }
    }

    public boolean isHasAvailableActions() throws Exception {
        return this.getBulkEditOperation().canPerform(this.getBulkEditBean(), this.getLoggedInApplicationUser());
    }

    private void updateBean() {
        this.getBulkEditBean().setActions(this.selectedActions);
        try {
            for (BulkEditAction bulkEditAction : this.getBulkEditBean().getActions().values()) {
                OrderableField field = bulkEditAction.getField();
                Object value = field.getValueFromParams(this.getBulkEditBean().getFieldValuesHolder());
                this.getBulkEditBean().getFieldValues().put(field.getId(), value);
            }
        }
        catch (FieldValidationException e) {
            this.log.error((Object)"Error getting field value.", (Throwable)e);
            throw new NestedRuntimeException("Error getting field value.", (Throwable)e);
        }
        this.getBulkEditBean().clearAvailablePreviousSteps();
        this.getBulkEditBean().addAvailablePreviousStep(1);
        this.getBulkEditBean().addAvailablePreviousStep(2);
        this.getBulkEditBean().addAvailablePreviousStep(3);
        this.setCurrentStep(4);
    }

    public Map getEditActions() {
        if (this.editActions == null) {
            this.editActions = this.getBulkEditOperation().getActions(this.getBulkEditBean(), this.getLoggedInApplicationUser());
        }
        return this.editActions;
    }

    public Collection getVisibleActions() {
        if (this.visibleActions == null) {
            this.seperateVisibleAndHiddenActions();
        }
        return this.visibleActions;
    }

    public Collection getHiddenActions() {
        if (this.hiddenActions == null) {
            this.seperateVisibleAndHiddenActions();
        }
        return this.hiddenActions;
    }

    private void seperateVisibleAndHiddenActions() {
        this.visibleActions = new ArrayList();
        this.hiddenActions = new ArrayList();
        for (BulkEditAction action : this.getEditActions().values()) {
            if (action.isAvailable(this.getBulkEditBean())) {
                this.visibleActions.add(action);
                continue;
            }
            this.hiddenActions.add(action);
        }
    }

    public boolean isAvailable(String action) throws Exception {
        return this.getEditActions().containsKey(action);
    }

    public Collection getCustomFields() {
        if (this.customFields == null) {
            this.customFields = new LinkedList();
        }
        return this.customFields;
    }

    public boolean isHasFirstElement(List actions) {
        return actions != null && !actions.isEmpty() && actions.get(0) != null;
    }

    public void setCurrentStep(int step) {
        this.getBulkEditBean().setCurrentStep(step);
    }

    public String[] getActions() {
        return this.actions;
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    private BulkEditOperation getBulkEditOperation() {
        return this.bulkEditOperation;
    }

    public String getOperationDetailsActionName() {
        return this.getBulkEditOperation().getOperationName() + "Details.jspa";
    }

    public boolean isChecked(String value) {
        if (this.getActions() == null || this.getActions().length == 0) {
            if (this.getBulkEditBean().getActions() != null) {
                return this.getBulkEditBean().getActions().containsKey(value);
            }
            return false;
        }
        for (int i = 0; i < this.getActions().length; ++i) {
            String action = this.getActions()[i];
            if (!action.equals(value)) continue;
            return true;
        }
        return false;
    }
}

