/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationDetailsAction;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;

public class BulkDelete
extends AbstractBulkOperationDetailsAction {
    private BulkOperation bulkDeleteOperation;
    final BulkOperationManager bulkOperationManager;
    private final PermissionManager permissionManager;

    public BulkDelete(SearchService searchService, BulkOperationManager bulkOperationManager, PermissionManager permissionManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper) {
        super(searchService, bulkEditBeanSessionHelper);
        this.bulkOperationManager = bulkOperationManager;
        this.permissionManager = permissionManager;
        this.bulkDeleteOperation = bulkOperationManager.getOperation("bulk.delete.operation.name");
    }

    public boolean isHasAvailableActions() throws Exception {
        return this.getBulkDeleteOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    public String getOperationDetailsActionName() {
        return this.getBulkDeleteOperation().getOperationName() + "Details.jspa";
    }

    public void doPerformValidation() {
        try {
            if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
            if (!this.getBulkDeleteOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.delete.cannotperform.error", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occured while testing operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.canperform.error"));
        }
    }

    @Override
    public String doDetails() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.delete.session.timeout.message");
        }
        if (this.isCanDisableMailNotifications() && this.getBulkEditBean().isHasMailServer()) {
            BulkEditBean bulkEditBean = this.getBulkEditBean();
            bulkEditBean.clearAvailablePreviousSteps();
            bulkEditBean.addAvailablePreviousStep(1);
            bulkEditBean.addAvailablePreviousStep(2);
            if (this.isCanDisableMailNotifications()) {
                bulkEditBean.setSendBulkNotification(false);
            } else {
                bulkEditBean.setSendBulkNotification(true);
            }
            bulkEditBean.setCurrentStep(3);
            return "input";
        }
        return this.getRedirect("BulkDeleteDetailsValidation.jspa");
    }

    @Override
    public String doDetailsValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.delete.session.timeout.message");
        }
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        bulkEditBean.clearAvailablePreviousSteps();
        bulkEditBean.addAvailablePreviousStep(1);
        bulkEditBean.addAvailablePreviousStep(2);
        bulkEditBean.addAvailablePreviousStep(3);
        bulkEditBean.setCurrentStep(4);
        return "input";
    }

    @Override
    @RequiresXsrfCheck
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.delete.session.timeout.message");
        }
        this.doPerformValidation();
        if (this.invalidInput()) {
            return "error";
        }
        try {
            this.getBulkDeleteOperation().perform(this.getBulkEditBean(), this.getLoggedInUser());
        }
        catch (Exception e) {
            this.log.error((Object)"Error while performing BulkDeleteOperation", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.delete.perform.error"));
            return "error";
        }
        return this.finishWizard();
    }

    public BulkOperation getBulkDeleteOperation() {
        return this.bulkDeleteOperation;
    }
}

