/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.MoveIssue;
import com.atlassian.jira.workflow.WorkflowManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import webwork.action.ActionContext;

public class MoveIssueSubtasks
extends MoveIssue {
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    Collection<IssueType> subtaskIssueTypes;
    Collection<IssueType> projectIssueTypes;

    public MoveIssueSubtasks(SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, IssueTypeSchemeManager issueTypeSchemeManager, UserUtil userUtil) {
        super(subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutManager, issueFactory, fieldScreenRendererFactory, commentService, userUtil);
        this.issueTypeSchemeManager = issueTypeSchemeManager;
    }

    @Override
    public String doDefault() {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        this.getMoveIssueBean().addAvailablePreviousStep(1);
        this.getMoveIssueBean().setCurrentStep(1);
        if (this.isNeedsSubtaskIssueTypeMigration()) {
            return "input";
        }
        try {
            return this.forceRedirect("MoveIssueUpdateWorkflow!default.jspa?id=" + this.id + "&assignee=" + URLEncoder.encode("" + this.getAssignee(), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String doExecute() {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        return this.forceRedirect("MoveIssueUpdateWorkflow!default.jspa?id=" + this.getIssue().getString("id"));
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            if (!this.hasIssuePermission(25, (Issue)this.getIssueObject())) {
                this.addErrorMessage(this.getText("move.issue.nopermissions"));
            } else {
                Map actionParameters = ActionContext.getParameters();
                for (IssueType issueType : this.getMigrateIssueTypes()) {
                    String key = this.getPrefixIssueTypeId(issueType.getId());
                    Object o = actionParameters.get(key);
                    if (o instanceof String[]) {
                        String[] strings = (String[])o;
                        String targetIssueTypeId = strings[0];
                        IssueType targetIssueType = this.constantsManager.getIssueTypeObject(targetIssueTypeId);
                        if (this.getProjectSubtaskIssueTypes().contains(targetIssueType)) {
                            this.getMoveIssueBean().getFieldValuesHolder().put(key, targetIssueTypeId);
                            continue;
                        }
                        this.addErrorMessage(this.getText("createissue.invalidissuetype"));
                        continue;
                    }
                    this.addErrorMessage(this.getText("createissue.invalidissuetype"));
                }
            }
        }
    }

    public Collection<IssueType> getProjectSubtaskIssueTypes() {
        if (this.projectIssueTypes == null) {
            Long projectId = this.getMoveIssueBean().getTargetPid();
            Project project = this.projectManager.getProjectObj(projectId);
            this.projectIssueTypes = this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(project);
        }
        return this.projectIssueTypes;
    }

    private boolean isNeedsSubtaskIssueTypeMigration() {
        return !this.getProjectSubtaskIssueTypes().containsAll(this.getSubtaskIssueTypes());
    }

    public Collection<IssueType> getMigrateIssueTypes() {
        HashSet<IssueType> subtaskIssueTypes = new HashSet<IssueType>(this.getSubtaskIssueTypes());
        subtaskIssueTypes.removeAll(this.getProjectSubtaskIssueTypes());
        return subtaskIssueTypes;
    }

    Collection<Issue> getSubtaskObjects() {
        return this.getSubTaskManager().getSubTaskObjects((Issue)this.getIssueObject());
    }

    Collection<IssueType> getSubtaskIssueTypes() {
        HashSet<IssueType> types = new HashSet<IssueType>();
        Collection<Issue> subtasks = this.getSubtaskObjects();
        for (Issue subTask : subtasks) {
            types.add(subTask.getIssueTypeObject());
        }
        return types;
    }
}

