/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.web.action.issue.IssueNavigatorSearchResultsHelper;
import com.atlassian.jira.web.action.issue.SearchActionHelper;
import com.atlassian.jira.web.action.issue.SearchResultsInfo;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.session.SessionPagerFilterManager;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.session.SessionSelectedIssueManager;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IssueNavigatorSearchResultsHelperImpl
implements IssueNavigatorSearchResultsHelper {
    private static final int FIND_ISSUE_WINDOW_SIZE = 20;
    private final SearchProvider searchProvider;
    private final JiraAuthenticationContext authContext;
    private final SearchActionHelper searchActionHelper;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;

    public IssueNavigatorSearchResultsHelperImpl(SearchProvider searchProvider, JiraAuthenticationContext authContext, SearchActionHelper searchActionHelper, SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory) {
        this.searchProvider = searchProvider;
        this.authContext = authContext;
        this.searchActionHelper = searchActionHelper;
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
    }

    public SearchResultsInfo getSearchResults(Query query, boolean isPageChanged) throws SearchException {
        boolean isReturningToSearch;
        SearchResultsInfo sr = new SearchResultsInfo();
        PagerFilter navigatorPager = this.getPager();
        final SessionSelectedIssueManager.SelectedIssueData selectedIssueData = (SessionSelectedIssueManager.SelectedIssueData)this.getSessionSelectedIssueManager().getCurrentObject();
        boolean bl = isReturningToSearch = !isPageChanged && selectedIssueData != null;
        if (isReturningToSearch) {
            SearchResults result;
            PagerFilter pager2;
            Predicate<Issue> currentIssuePredicate = new Predicate<Issue>(){

                public boolean evaluate(Issue input) {
                    return input.getId().equals(selectedIssueData.getSelectedIssueId());
                }
            };
            Predicate<Issue> nextIssuePredicate = new Predicate<Issue>(){

                public boolean evaluate(Issue input) {
                    return input.getId().equals(selectedIssueData.getNextIssueId());
                }
            };
            int expectedIndex = selectedIssueData.getSelectedIssueIndex();
            int fromIndex = Math.max(0, expectedIndex - 20);
            int toIndexExclusive = expectedIndex + 20 + 1;
            List<PagerFilter> searchWindowPagers = IssueNavigatorSearchResultsHelperImpl.pagersToSearch(navigatorPager, fromIndex, expectedIndex, toIndexExclusive);
            ArrayList<SearchResults> searchWindowResults = new ArrayList<SearchResults>();
            for (PagerFilter pager2 : searchWindowPagers) {
                result = this.searchProvider.search(query, this.getLoggedInUser(), new PagerFilter(pager2));
                Issue currentIssue = (Issue)CollectionUtil.findFirstMatch(IssueNavigatorSearchResultsHelperImpl.intersection(result.getIssues(), pager2, fromIndex, toIndexExclusive), (Predicate)currentIssuePredicate);
                if (currentIssue != null) {
                    this.setPagerStart(pager2.getStart());
                    sr.selectedIssueId = currentIssue.getId();
                    sr.searchResults = result;
                    break;
                }
                searchWindowResults.add(result);
            }
            if (sr.searchResults == null) {
                for (int i = 0; i < searchWindowPagers.size(); ++i) {
                    pager2 = searchWindowPagers.get(i);
                    result = (SearchResults)searchWindowResults.get(i);
                    Issue nextIssue = (Issue)CollectionUtil.findFirstMatch(IssueNavigatorSearchResultsHelperImpl.intersection(result.getIssues(), pager2, fromIndex, toIndexExclusive), (Predicate)nextIssuePredicate);
                    if (nextIssue == null) continue;
                    this.setPagerStart(pager2.getStart());
                    sr.selectedIssueId = nextIssue.getId();
                    sr.searchResults = result;
                    break;
                }
            }
            if (sr.searchResults == null) {
                if (searchWindowResults.isEmpty()) {
                    sr.searchResults = this.searchProvider.search(query, this.getLoggedInUser(), navigatorPager);
                } else {
                    SearchResults result2 = (SearchResults)searchWindowResults.get(0);
                    if (!result2.getIssues().isEmpty()) {
                        this.setPagerStart(result2.getStart());
                        sr.searchResults = result2;
                    } else {
                        pager2 = new PagerFilter(navigatorPager);
                        pager2.setStart(0);
                        sr.searchResults = this.searchProvider.search(query, this.getLoggedInUser(), pager2);
                    }
                }
            }
        } else {
            sr.searchResults = this.searchProvider.search(query, this.getLoggedInUser(), navigatorPager);
        }
        return sr;
    }

    public void ensureAnIssueIsSelected(final SearchResultsInfo sr, boolean isPagingToPreviousPage) {
        List issuesInPage = sr.searchResults.getIssues();
        Long nextIssueId = null;
        if (!issuesInPage.isEmpty()) {
            int selectedIssueIndex;
            if (isPagingToPreviousPage) {
                sr.selectedIssueId = ((Issue)issuesInPage.get(issuesInPage.size() - 1)).getId();
                selectedIssueIndex = sr.searchResults.getStart() + issuesInPage.size() - 1;
            } else {
                boolean isSelectedIssueInPage;
                int index = CollectionUtil.indexOf((Iterable)issuesInPage, (Predicate)new Predicate<Issue>(){

                    public boolean evaluate(Issue input) {
                        return input.getId().equals(sr.selectedIssueId);
                    }
                });
                boolean bl = isSelectedIssueInPage = index >= 0;
                if (isSelectedIssueInPage) {
                    selectedIssueIndex = sr.searchResults.getStart() + index;
                    if (index < issuesInPage.size() - 1) {
                        nextIssueId = ((Issue)issuesInPage.get(index + 1)).getId();
                    }
                } else {
                    sr.selectedIssueId = ((Issue)issuesInPage.get(0)).getId();
                    selectedIssueIndex = sr.searchResults.getStart();
                    if (issuesInPage.size() > 1) {
                        nextIssueId = ((Issue)issuesInPage.get(1)).getId();
                    }
                }
            }
            this.getSessionSelectedIssueManager().setCurrentObject(new SessionSelectedIssueManager.SelectedIssueData(sr.selectedIssueId, selectedIssueIndex, nextIssueId));
        } else {
            this.clearSelectedIssue();
        }
    }

    public void resetPagerAndSelectedIssue() {
        this.searchActionHelper.resetPager();
        this.clearSelectedIssue();
    }

    private static List<PagerFilter> pagersToSearch(PagerFilter pager, int fromIndex, int expectedIndex, int toIndexExclusive) {
        int pageSize = pager.getPageSize();
        ArrayList<PagerFilter> pagers = new ArrayList<PagerFilter>();
        PagerFilter expectedPagePager = PagerFilter.newPageAlignedFilter((int)expectedIndex, (int)pageSize);
        if (IssueNavigatorSearchResultsHelperImpl.isOverlapping(expectedPagePager, fromIndex, toIndexExclusive)) {
            pagers.add(expectedPagePager);
        }
        PagerFilter left = expectedPagePager.getStart() == 0 ? null : new PagerFilter(expectedPagePager.getStart() - pageSize, pageSize);
        PagerFilter right = new PagerFilter(expectedPagePager.getStart() + pageSize, pageSize);
        while (left != null && IssueNavigatorSearchResultsHelperImpl.isOverlapping(left, fromIndex, toIndexExclusive) || IssueNavigatorSearchResultsHelperImpl.isOverlapping(right, fromIndex, toIndexExclusive)) {
            if (left != null && IssueNavigatorSearchResultsHelperImpl.isOverlapping(left, fromIndex, toIndexExclusive)) {
                pagers.add(left);
                PagerFilter pagerFilter = left = left.getStart() == 0 ? null : new PagerFilter(left.getStart() - pageSize, pageSize);
            }
            if (!IssueNavigatorSearchResultsHelperImpl.isOverlapping(right, fromIndex, toIndexExclusive)) continue;
            pagers.add(right);
            right = new PagerFilter(right.getStart() + pageSize, pageSize);
        }
        return pagers;
    }

    private static boolean isOverlapping(PagerFilter pager, int fromIndex, int toIndexExclusive) {
        return pager.getStart() < toIndexExclusive && fromIndex < pager.getStart() + pager.getPageSize();
    }

    static List<Issue> intersection(List<Issue> issuesInPage, PagerFilter pager, int fromIndex, int toIndexExclusive) {
        if (fromIndex >= pager.getStart() + issuesInPage.size()) {
            return Collections.emptyList();
        }
        if (IssueNavigatorSearchResultsHelperImpl.isOverlapping(pager, fromIndex, toIndexExclusive)) {
            int offset = pager.getStart();
            return issuesInPage.subList(Math.max(0, fromIndex - offset), Math.min(Math.max(0, toIndexExclusive - offset), issuesInPage.size()));
        }
        return Collections.emptyList();
    }

    private void clearSelectedIssue() {
        this.getSessionSelectedIssueManager().setCurrentObject(new SessionSelectedIssueManager.SelectedIssueData(null, 0, null));
    }

    private User getLoggedInUser() {
        return this.authContext.getLoggedInUser();
    }

    private void setPagerStart(int start) {
        this.getPager().setStart(start);
    }

    private PagerFilter getPager() {
        PagerFilter pager = (PagerFilter)this.getSessionPagerFilterManager().getCurrentObject();
        if (pager == null) {
            pager = this.searchActionHelper.resetPager();
        }
        return pager;
    }

    private SessionSelectedIssueManager getSessionSelectedIssueManager() {
        return this.sessionSearchObjectManagerFactory.createSelectedIssueManager();
    }

    private SessionPagerFilterManager getSessionPagerFilterManager() {
        return this.sessionSearchObjectManagerFactory.createPagerFilterManager();
    }
}

