/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class IssueCreationHelperBeanImpl
implements IssueCreationHelperBean {
    private final UserUtil userUtil;
    private final FieldManager fieldManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final JiraLicenseService jiraLicenseService;
    private final JiraContactHelper jiraContactHelper;

    public IssueCreationHelperBeanImpl(UserUtil userUtil, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, JiraLicenseService jiraLicenseService, JiraContactHelper jiraContactHelper) {
        this.userUtil = userUtil;
        this.fieldManager = fieldManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.jiraContactHelper = jiraContactHelper;
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
    }

    public void validateCreateIssueFields(JiraServiceContext jiraServiceContext, Collection<String> providedFields, Issue issueObject, FieldScreenRenderer fieldScreenRenderer, OperationContext operationContext, Map<String, String[]> actionParams, boolean applyDefaults, I18nHelper i18n) {
        ErrorCollection errors = jiraServiceContext.getErrorCollection();
        FieldLayout fieldLayout = fieldScreenRenderer.getFieldLayout();
        List visibleLayoutItems = fieldLayout.getVisibleLayoutItems(issueObject.getProjectObject(), (List)Lists.newArrayList((Object[])new String[]{issueObject.getIssueTypeObject().getId()}));
        for (FieldLayoutItem fieldLayoutItem : visibleLayoutItems) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            if ("issuetype".equals(orderableField.getId())) continue;
            FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = fieldScreenRenderer.getFieldScreenRenderLayoutItem(orderableField);
            if (fieldScreenRenderLayoutItem != null && fieldScreenRenderLayoutItem.isShow(issueObject) && providedFields.contains(orderableField.getId())) {
                if (!orderableField.hasParam(actionParams) && applyDefaults) {
                    orderableField.populateDefaults(operationContext.getFieldValuesHolder(), issueObject);
                } else {
                    orderableField.populateFromParams(operationContext.getFieldValuesHolder(), actionParams);
                }
                try {
                    orderableField.validateParams(operationContext, errors, i18n, issueObject, fieldScreenRenderLayoutItem);
                }
                catch (FieldValidationException e) {
                    errors.addError(orderableField.getId(), e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                continue;
            }
            if ("resolution".equals(orderableField.getId())) continue;
            orderableField.populateDefaults(operationContext.getFieldValuesHolder(), issueObject);
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            try {
                orderableField.validateParams(operationContext, (ErrorCollection)errorCollection, i18n, issueObject, fieldScreenRenderLayoutItem);
            }
            catch (FieldValidationException e) {
                errorCollection.addError(orderableField.getId(), e.getMessage());
            }
            if (errorCollection.getErrors() != null && !errorCollection.getErrors().isEmpty()) {
                for (String s : errorCollection.getErrors().values()) {
                    String result = orderableField instanceof CustomField ? orderableField.getName() : i18n.getText(orderableField.getNameKey());
                    errors.addErrorMessage(result + ": " + s);
                }
            }
            errors.addErrorMessages(errorCollection.getErrorMessages());
            errors.addReasons(errorCollection.getReasons());
        }
    }

    public void validateLicense(ErrorCollection errors, I18nHelper i18n) {
        String contactLink = this.jiraContactHelper.getAdministratorContactMessage(i18n);
        LicenseDetails licenseDetails = this.getLicenseDetails();
        if (!licenseDetails.isLicenseSet()) {
            errors.addErrorMessage(i18n.getText("createissue.error.invalid.license", contactLink), ErrorCollection.Reason.FORBIDDEN);
        } else if (licenseDetails.isExpired()) {
            errors.addErrorMessage(i18n.getText("createissue.error.license.expired", contactLink), ErrorCollection.Reason.FORBIDDEN);
        } else if (this.userUtil.hasExceededUserLimit()) {
            errors.addErrorMessage(i18n.getText("createissue.error.license.user.limit.exceeded", contactLink), ErrorCollection.Reason.FORBIDDEN);
        }
    }

    LicenseDetails getLicenseDetails() {
        return this.jiraLicenseService.getLicense();
    }

    public void updateIssueFromFieldValuesHolder(FieldScreenRenderer fieldScreenRenderer, User remoteUser, MutableIssue issueObject, Map fieldValuesHolder) {
        this.updateIssueFromFieldValuesHolder(fieldScreenRenderer, issueObject, fieldValuesHolder);
    }

    public void updateIssueFromFieldValuesHolder(FieldScreenRenderer fieldScreenRenderer, MutableIssue issueObject, Map fieldValuesHolder) {
        FieldLayout fieldLayout = fieldScreenRenderer.getFieldLayout();
        List visibleLayoutItems = fieldLayout.getVisibleLayoutItems(issueObject.getProjectObject(), (List)Lists.newArrayList((Object[])new String[]{issueObject.getIssueTypeObject().getId()}));
        for (FieldLayoutItem fieldLayoutItem : visibleLayoutItems) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            if ("issuetype".equals(orderableField.getId())) continue;
            orderableField.updateIssue(fieldLayoutItem, issueObject, fieldValuesHolder);
        }
    }

    public FieldScreenRenderer createFieldScreenRenderer(User remoteUser, Issue issueObject) {
        return this.createFieldScreenRenderer(issueObject);
    }

    public FieldScreenRenderer createFieldScreenRenderer(Issue issueObject) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issueObject, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION);
    }

    public List<String> getProvidedFieldNames(User remoteUser, Issue issueObject) {
        return this.getProvidedFieldNames(issueObject);
    }

    public List<String> getProvidedFieldNames(Issue issueObject) {
        ArrayList<String> providedFieldNames = new ArrayList<String>();
        FieldScreenRenderer fieldScreenRenderer = this.createFieldScreenRenderer(issueObject);
        List visibleLayoutItems = fieldScreenRenderer.getFieldLayout().getVisibleLayoutItems(issueObject.getProjectObject(), (List)Lists.newArrayList((Object[])new String[]{issueObject.getIssueTypeObject().getId()}));
        for (FieldLayoutItem fieldLayoutItem : visibleLayoutItems) {
            String fieldId = fieldLayoutItem.getOrderableField().getId();
            providedFieldNames.add(fieldId);
        }
        return providedFieldNames;
    }

    public List<OrderableField> getFieldsForCreate(User user, Issue issueObject) {
        ArrayList<OrderableField> fields = new ArrayList<OrderableField>();
        FieldScreenRenderer fieldScreenRenderer = this.createFieldScreenRenderer(issueObject);
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                if (!fieldScreenRenderLayoutItem.isShow(issueObject)) continue;
                fields.add(fieldScreenRenderLayoutItem.getOrderableField());
            }
        }
        return fields;
    }

    public void validateProject(Issue issue, OperationContext operationContext, Map actionParams, ErrorCollection errors, I18nHelper i18n) {
        ProjectSystemField projectField = (ProjectSystemField)this.getField("project");
        projectField.populateFromParams(operationContext.getFieldValuesHolder(), actionParams);
        projectField.validateParams(operationContext, errors, i18n, issue, null);
    }

    public void validateIssueType(Issue issue, OperationContext operationContext, Map actionParams, ErrorCollection errors, I18nHelper i18n) {
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.getField("issuetype");
        issueTypeField.populateFromParams(operationContext.getFieldValuesHolder(), actionParams);
        issueTypeField.validateParams(operationContext, errors, i18n, issue, null);
    }

    public void validateSummary(Issue issue, OperationContext operationContext, Map actionParams, ErrorCollection errors, I18nHelper i18n) {
        SummarySystemField field = (SummarySystemField)this.getField("summary");
        field.populateFromParams(operationContext.getFieldValuesHolder(), actionParams);
        field.validateParams(operationContext, errors, i18n, issue, null);
    }

    public Field getField(String id) {
        return this.fieldManager.getField(id);
    }
}

