/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import java.util.HashMap;
import java.util.Map;
import webwork.action.ActionContext;

public class EditComment
extends AbstractCommentableIssue {
    private CommentService commentService;
    private Long commentId;
    private MutableComment commentObject;
    private static final String ERROR_KEY_NO_ASSOC_ISSUE = "edit.comment.no.associated.issue";
    private static final String ERROR_NO_PERMISSION = "errorNoPermission";

    public EditComment(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.commentService = commentService;
    }

    @Override
    protected void doValidation() {
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (!this.commentService.hasPermissionToEdit(this.getJiraServiceContext(), this.getCommentId())) {
            return ERROR_NO_PERMISSION;
        }
        CommentVisibility commentVisibility = new CommentVisibility(this.getCommentLevel());
        String roleLevel = commentVisibility.getRoleLevel();
        CommentService.CommentParameters commentParameters = CommentService.CommentParameters.builder().body(this.getComment()).groupLevel(commentVisibility.getGroupLevel()).roleLevelId(roleLevel == null ? null : new Long(roleLevel)).commentProperties(CommentSystemField.getCommentPropertiesFromParameters(ActionContext.getParameters())).build();
        CommentService.CommentUpdateValidationResult validationResult = this.commentService.validateCommentUpdate(this.getLoggedInApplicationUser(), this.getCommentId(), commentParameters);
        OrderableField field = (OrderableField)ComponentAccessor.getFieldManager().getField("comment");
        field.populateFromParams(this.getFieldValuesHolder(), ActionContext.getParameters());
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (validationResult.isValid()) {
            this.commentService.update(this.getLoggedInApplicationUser(), validationResult, true);
            String baseUrl = "/browse/" + ((Comment)validationResult.getComment().get()).getIssue().getKey();
            UrlBuilder urlBuilder = new UrlBuilder(baseUrl);
            urlBuilder.addParameter("focusedCommentId", this.getCommentId().toString());
            urlBuilder.addParameter("page", "com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
            urlBuilder.addAnchor("comment-" + this.getCommentId().toString());
            return this.returnComplete(urlBuilder.asUrlString());
        }
        this.addErrorCollection(validationResult.getErrorCollection());
        return "error";
    }

    public String doDefault() throws Exception {
        if (!this.commentService.hasPermissionToEdit(this.getJiraServiceContext(), this.getCommentId())) {
            return ERROR_NO_PERMISSION;
        }
        MutableComment commentObject = this.getCommentObject();
        if (commentObject == null) {
            return "error";
        }
        if (!this.commentService.hasPermissionToEdit(this.getLoggedInApplicationUser(), (Comment)commentObject, (ErrorCollection)this)) {
            return "error";
        }
        HashMap<String, Object> initialValues = new HashMap<String, Object>();
        initialValues.put("comment", new String[]{commentObject.getBody()});
        initialValues.put("commentLevel", new String[]{CommentVisibility.getCommentLevelFromLevels(commentObject.getGroupLevel(), commentObject.getRoleLevelId())});
        initialValues.put("commentObject", commentObject);
        OrderableField commentField = (OrderableField)this.getField("comment");
        commentField.populateFromParams(this.getFieldValuesHolder(), initialValues);
        return super.doDefault();
    }

    public void setCommentId(Long id) {
        this.commentId = id;
    }

    public Long getCommentId() {
        return this.commentId;
    }

    public MutableComment getCommentObject() {
        if (this.commentObject == null) {
            this.commentObject = this.commentService.getMutableComment(this.getLoggedInApplicationUser(), this.getCommentId(), (ErrorCollection)this);
        }
        return this.commentObject;
    }

    public String getCommentAuthorKey() {
        ApplicationUser commentAuthor = this.getCommentObject().getAuthorApplicationUser();
        return commentAuthor == null ? null : commentAuthor.getKey();
    }

    public String getCommentUpdateAuthorKey() {
        ApplicationUser commentUpdater = this.getCommentObject().getUpdateAuthorApplicationUser();
        return commentUpdater == null ? null : commentUpdater.getKey();
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

