/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.issue.IssueMetadataHelper;
import java.util.HashMap;
import java.util.Map;

public class DefaultIssueMetadataHelper
implements IssueMetadataHelper {
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarService avatarService;
    private final PermissionManager permissionManager;
    private final UserPickerSearchService userPickerSearchService;

    public DefaultIssueMetadataHelper(JiraAuthenticationContext authenticationContext, AvatarService avatarService, PermissionManager permissionManager, UserPickerSearchService userPickerSearchService) {
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.permissionManager = permissionManager;
        this.userPickerSearchService = userPickerSearchService;
    }

    @Override
    public Map<String, String> getMetadata(Issue issue, SearchRequest searchRequest) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("can-edit-watchers", this.canEditWatchers(issue));
        metadata.put("can-search-users", this.canSearchUsers());
        metadata.put("default-avatar-url", this.getDefaultAvatarURL());
        metadata.put("issue-key", issue.getKey());
        return metadata;
    }

    @Override
    public void putMetadata(Issue issue, SearchRequest searchRequest, JiraWebResourceManager webResourceManager) {
        Map<String, String> metadata = this.getMetadata(issue, searchRequest);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            webResourceManager.putMetadata(entry.getKey(), entry.getValue());
        }
    }

    private String canEditWatchers(Issue issue) {
        return Boolean.toString(this.permissionManager.hasPermission(32, issue, this.getLoggedInUser()));
    }

    private String canSearchUsers() {
        return Boolean.toString(this.userPickerSearchService.canPerformAjaxSearch(this.getLoggedInUser()));
    }

    private String getDefaultAvatarURL() {
        return this.avatarService.getAvatarURL(this.getLoggedInUser(), null, Avatar.Size.SMALL).toString();
    }

    private User getLoggedInUser() {
        return this.authenticationContext.getLoggedInUser();
    }
}

